<?php

class ControladorDocumental{


	/*=============================================
	REGISTRO DE PROPIETARIO
	=============================================*/

	static public function ctrCrearPropietario(){

		if(isset($_POST["nuevoCi"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreProp"]) 
			   ){
				$fec_ing = $_POST["nuevoFecingreso"];
				// Crear un objeto DateTime desde la cadena de fecha original
				$date = DateTime::createFromFormat('d/m/Y', $fec_ing);
				// Formatear la fecha al formato 'Y-m-d' (año-mes-día)
				$fec_ingreso = $date->format('Y-m-d');
				$usuario = $_SESSION["gUsuario"];

				$tabla = "tx_propietarios";									 
				$datos = array("ci" => $_POST["nuevoCi"],
								"nombres" => strtoupper($_POST["nuevoNombreProp"]),
								"apellidos" => strtoupper($_POST["nuevoApellidos"]),
								"fec_ingreso" => $fec_ingreso,
								"celular" => $_POST["nuevoCelular"],
							   "direc_zona" => strtoupper($_POST["nuevoZona"]),
					           "direc_calle" => strtoupper($_POST["nuevoCalle"]),
					           "antecedentes" => $_POST["nuevoAntecedentes"],
					           "permiso" => $_POST["nuevoPermiso"],
								"usuario" => $usuario);

				$respuesta = ModeloPropietarios::mdlIngresarPropietarios($tabla, $datos);
			
				if($respuesta == "ok"){

					echo '<script>
						Swal.fire({
							icon: "success",
							title: "¡El Propietario ha sido guardado correctamente!",
							showConfirmButton: true,
							confirmButtonText: "CERRAR"
						}).then((result) => {
							if (result.isConfirmed) {
								window.location = "frmpropietarios";
							}
						});
					</script>';
				}	
			}else{

				echo '<script>
					Swal.fire({
						icon: "error",
						title: "¡El nombre no puede ir vacío o llevar caracteres especiales!",
						showConfirmButton: true,
						confirmButtonText: "CERRAR"
					}).then((result) => {
						if (result.isConfirmed) {
							window.location = "frmpropietarios";
						}
					});
				</script>';
			}
		}
	}

	/*=============================================
	MOSTRAR DOCUMENTOS
	=============================================*/

	static public function ctrMostrarDocumentos($item, $valor){

		$tabla = "tx_documental";

		$respuesta = ModeloDocumental::MdlMostrarDocumentos($tabla, $item, $valor);

		return $respuesta;
	}


	/*=============================================
	EDITAR DOCUMENTAL
	=============================================*/

	static public function ctrEditarDocumental(){

		if(isset($_POST["editarciDocu"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarNombreDocu"])){

				/*=============================================
				VALIDAR IMAGEN
				=============================================*/

				switch ($_POST["editarDocumento"]) {
						case "Licencia":
							$ruta = $_POST["fotoLicencia"];
							$item = "imglicencia";
							break;
						case "Croquis":
							$ruta = $_POST["fotoCroquis"];
							$item = "imgcroquis";
							break;
						case "Antecedentes":
							$ruta = $_POST["fotoAnteced"];
							$item = "imgcertantece";
							break;
						case "cvLinea":
							$ruta = $_POST["fotocvLinea"];
							$item = "imgcovelinea";
							break;
						case "traLinea":
							$ruta = $_POST["fototraLinea"];
							$item = "imgtranslinea";
							break;
						case "ingHerramienta":
							$ruta = $_POST["fotoingHerram"];
							$item = "imgingherramienta";
							break;
						case "Ruat":
							$ruta = $_POST["fotoRuat"];
							$item = "imgruat";
							break;
						case "Soat":
							$ruta = $_POST["fotoSoat"];
							$item = "imgsoat";
							break;
						case "Carnet":
							$ruta = $_POST["fotoCarnet"];
							$item = "imgcarnet";
							break;
						case "PerVigente":
							$ruta = $_POST["fotoPerVigent"];
							$item = "imgpermivigente";
							break;
						case "Garante":
							$ruta = $_POST["fotoGarante"];
							$item = "imggarente";
							break;
				}
				//echo("<script>console.log('PHP: " . $_POST["editarDocumento"] . "');</script>");

				//$ruta = $_POST["fotoLicencia"];

				if(isset($_FILES["editarFoto"]["tmp_name"]) && !empty($_FILES["editarFoto"]["tmp_name"])){

					list($ancho, $alto) = getimagesize($_FILES["editarFoto"]["tmp_name"]);

					$nuevoAncho = 500;
					$nuevoAlto = 500;
				
					$direcimg = "";

					switch ($_POST["editarDocumento"]) {
						case "Licencia":

							/*=============================================
							CREAMOS EL DIRECTORIO DONDE VAMOS A GUARDAR LA FOTO DEL USUARIO
							=============================================*/

							$directorio = "vistas/img/documentos/licencias/".$_POST["editarciDocu"];

							/*=============================================
							PRIMERO PREGUNTAMOS SI EXISTE OTRA IMAGEN EN LA BD
							=============================================*/

							if(!empty($_POST["fotoLicencia"])){

								unlink($_POST["fotoLicencia"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "licencias";	
							break;
						case "Croquis":

							$directorio = "vistas/img/documentos/croquis/".$_POST["editarciDocu"];

							if(!empty($_POST["fotoCroquis"])){

								unlink($_POST["fotoCroquis"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "croquis";	
							break;
						case "Antecedentes":
							$directorio = "vistas/img/documentos/antecedentes/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoAnteced"])){

								unlink($_POST["fotoAnteced"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "antecedentes";	
							break;
						case "cvLinea":
							$directorio = "vistas/img/documentos/cvlinea/".$_POST["editarciDocu"];
							if(!empty($_POST["fotocvLinea"])){

								unlink($_POST["fotocvLinea"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "cvlinea";	
							break;
						case "traLinea":
							$directorio = "vistas/img/documentos/tralinea/".$_POST["editarciDocu"];
							if(!empty($_POST["fototraLinea"])){

								unlink($_POST["fototraLinea"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "tralinea";	
							break;
						case "ingHerramienta":
							$directorio = "vistas/img/documentos/ingherramienta/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoingHerram"])){

								unlink($_POST["fotoingHerram"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "ingherramienta";	
							break;
						case "Ruat":
							$directorio = "vistas/img/documentos/ruat/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoRuat"])){

								unlink($_POST["fotoRuat"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "ruat";	
							break;
						case "Soat":
							$directorio = "vistas/img/documentos/soat/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoSoat"])){

								unlink($_POST["fotoSoat"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "soat";	
							break;
						case "Carnet":
							$directorio = "vistas/img/documentos/carnet/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoCarnet"])){

								unlink($_POST["fotoCarnet"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "carnet";	
							break;
						case "PerVigente":
							$directorio = "vistas/img/documentos/pervigente/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoPerVigent"])){

								unlink($_POST["fotoPerVigent"]);
		
							}else{
		
								mkdir($directorio, 0755);
		
							}
							$direcimg = "pervigente";	
							break;
						case "Garante":
							$directorio = "vistas/img/documentos/garante/".$_POST["editarciDocu"];
							if(!empty($_POST["fotoGarante"])){

								unlink($_POST["fotoGarante"]);
		
							}else{
		
								mkdir($directorio, 0755);
							}
							$direcimg = "garante";	
							break;
					}

					/*=============================================
					DE ACUERDO AL TIPO DE IMAGEN APLICAMOS LAS FUNCIONES POR DEFECTO DE PHP
					=============================================*/

					if($_FILES["editarFoto"]["type"] == "image/jpeg"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/documentos/".$direcimg."/".$_POST["editarciDocu"]."/".$aleatorio.".jpg";

						$origen = imagecreatefromjpeg($_FILES["editarFoto"]["tmp_name"]);						

						$destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);

						imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);

						imagejpeg($destino, $ruta);

					}

					if($_FILES["editarFoto"]["type"] == "image/png"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/documentos/".$direcimg."/".$_POST["editarciDocu"]."/".$aleatorio.".png";

						$origen = imagecreatefrompng($_FILES["editarFoto"]["tmp_name"]);						

						$destino = imagecreatetruecolor($nuevoAncho, $nuevoAlto);

						imagecopyresized($destino, $origen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $ancho, $alto);

						imagepng($destino, $ruta);

					}

				}

				$tabla = "tx_documental";
				
				$usuario = $_SESSION["gUsuario"];

				$datos = array("ci" => $_POST["editarciDocu"],
								"foto" => $ruta,
								"usuario" => $usuario);

				$respuesta = ModeloDocumental::mdlEditarDocumental($tabla, $item, $datos);

				if($respuesta == "ok"){

					echo'<script>

					Swal.fire({
					      icon: "success",
						  type: "success",
						  title: "El Documento fue cargado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "frmdocumental";

									}
								})

					</script>';

				}
				
			}else{
				echo '<script>
					Swal.fire({
						icon: "error",
						title: "¡El Nombre no puede ir vacío o llevar caracteres especiales!",
						showConfirmButton: true,
						confirmButtonText: "CERRAR"
					}).then((result) => {
						if (result.isConfirmed) {
							window.location = "frmdocumental";
						}
					});
				</script>';

			}
		}

	}

	/*=============================================
	BAJA DE PROPIETARIO
	=============================================*/

	static public function ctrBajaPropietario(){

		if(isset($_POST["editBajaProp"])){

			$tabla = "tx_propietarios";

			$usuario = $_SESSION["gUsuario"];

			$datos = array(	"ci" => strtoupper($_POST["editBajaProp"]),
							"usuario" => $usuario);

			$respuesta = ModeloPropietarios::mdlBajaPropietario($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				Swal.fire({
					  icon: "success",
					  type: "success",
					  title: "El Propietario fue dado de Baja",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar"
					  }).then(function(result){
								if (result.value) {

								window.location = "frmbajapropietarios";

								}
							})

				</script>';

			}	

		}

	}

}
	


