<?php

require_once "../../../modelos/cobrosmensuales.modelo.php";

class imprimirReciboMensual{

public $nroRecMenGET;
public $fec_actualGET;

public function impresionReciboMensual(){

$nroRecMens = $this->nroRecMenGET;
$fec_actual = $this->fec_actualGET;



$datos = array("nroRecMensual" => $nroRecMens);

$respuesta = ModeloMensuales::mdlReciboMensual($datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$margen_izquierdo = 8;  // Margen izquierdo en mm
$margen_superior = 20;   // Margen superior en mm
$margen_derecho = 8;    // Margen derecho en mm

$pdf->SetMargins($margen_izquierdo, $margen_superior, $margen_derecho);

$pdf->startPageGroup();

$pdf->AddPage();

// ----------------------------------------------------------------------------

foreach ($respuesta as $key => $item) {

	$literal = numeroALetras($item['Monto']);

	$bloque1 = <<<EOD
	<br>
	<br>
	<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td width="45%">
				<h4 style="font-size:9px; text-align: center;">ORIGINAL</h4>
				<table border="1" cellpadding="2" cellspacing="0">
					<tr><td colspan="2" style="font-size:9px; text-align: center;"><strong>RECIBO COBRO MENSUAL 0000{$item['NroRecibo']}</strong></td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>CI</strong></td><td width="70%" style="font-size:9px;">{$item['ci']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>SOCIO</strong></td><td width="70%" style="font-size:9px;">{$item['Socio']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>NRO CELULAR</strong></td><td width="70%" style="font-size:9px;">{$item['Celular']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>CONDICIÓN</strong></td><td width="70%" style="font-size:9px;">{$item['Tipo']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>CONCEPTO</strong></td><td width="70%" style="font-size:9px;">Pago por {$item['Rubro']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>FECHA</strong></td><td width="70%" style="font-size:9px;">{$item['Fecha']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>MONTO TOTAL</strong></td><td width="70%" style="font-size:9px;"><strong>{$item['Monto']} Bs $literal</strong></td></tr>
				</table>
				<table border="0" cellpadding="2" cellspacing="0" style="width: 100%; text-align: center;">
					<tr>
						<td style="height: 20px;"></td>
						<td style="height: 20px;"></td>
					</tr>
					<tr>
						<td style="height: 20px;"></td>
						<td style="height: 20px;"></td>
					</tr>
					<tr>
						<td style="font-size:8px;"><strong>ENTREGUE CONFORME</strong></td>
						<td style="font-size:8px;"><strong>SELLO FIRMA HACIENDA</strong></td>
					</tr>
				</table>
			</td>
			<td width="10%"></td>
			<td width="45%">
				<h4 style="font-size:9px; text-align: center;">COPIA</h4>
				<table border="1" cellpadding="2" cellspacing="0">
					<tr><td colspan="2" style="font-size:9px; text-align: center;"><strong>RECIBO COBRO MENSUAL 0000{$item['NroRecibo']}</strong></td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>CI</strong></td><td width="70%" style="font-size:9px;">{$item['ci']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>SOCIO</strong></td><td width="70%" style="font-size:9px;">{$item['Socio']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>NRO CELULAR</strong></td><td width="70%" style="font-size:9px;">{$item['Celular']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>CONDICIÓN</strong></td><td width="70%" style="font-size:9px;">{$item['Tipo']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>CONCEPTO</strong></td><td width="70%" style="font-size:9px;">Pago por {$item['Rubro']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>FECHA</strong></td><td width="70%" style="font-size:9px;">{$item['Fecha']}</td></tr>
					<tr><td width="30%" style="font-size:9px;"><strong>MONTO TOTAL</strong></td><td width="70%" style="font-size:9px;"><strong>{$item['Monto']} Bs $literal</strong></td></tr>
				</table>
				<!-- Firma y sello -->
				<table border="0" cellpadding="2" cellspacing="0" style="width: 100%; text-align: center;">
					<tr>
						<td style="height: 20px;"></td>
						<td style="height: 20px;"></td>
					</tr>
					<tr>
						<td style="height: 20px;"></td>
						<td style="height: 20px;"></td>
					</tr>
					<tr>
						<td style="font-size:8px;"><strong>ENTREGUE CONFORME</strong></td>
						<td style="font-size:8px;"><strong>SELLO FIRMA HACIENDA</strong></td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($bloque1, true, false, false, false, '');

	
}

// ---------------------------------------------------------

//SALIDA DEL ARCHIVO 

$pdf->Output('ComprobanteMensual.pdf', 'I');

}

}

$Reporte = new imprimirReciboMensual();
$Reporte -> nroRecMenGET = $_GET["nroRecMen"];
$Reporte -> fec_actualGET = $_GET["fec_actual"];
$Reporte -> impresionReciboMensual();

function numeroALetras($numero) {
    $formatter = new NumberFormatter("es", NumberFormatter::SPELLOUT);
    
    // Separar la parte entera y la parte decimal
    $partes = explode('.', number_format($numero, 2, '.', ''));
    $parteEntera = $partes[0];
    //$parteDecimal = isset($partes[1]) ? $partes[1] : '00';
	$parteDecimal = '100';

    // Convertir la parte entera a letras
    $literal = ucfirst($formatter->format($parteEntera));
	$cero = "00";
    // Agregar la parte decimal en formato de centavos
    $moneda = "Bolivianos";
    $literal .= " $cero/$parteDecimal $moneda";

    return $literal;
}

?>