<?php

require_once "../../../modelos/egresos.modelo.php";
require_once('tcpdf_include.php');

class MYPDF extends TCPDF {
    // Pie de página personalizado
    public function Footer() {
        // Posiciona el texto a 15 mm del final de la página
        $this->SetY(-15);
        // Establece fuente y estilo
        $this->SetFont('helvetica', '', 8);
        // Texto centrado
        $this->Cell(0, 10, 'Sistema Correnet V. 2.0', 0, false, 'C');
    }
}


class imprimirComprobantesEgreso{

public $nroCompEgrGET;
public $fec_actualGET;
public $tipocompGET;

public function impresionNotaJefatura(){

$nroCompEgr = $this->nroCompEgrGET;
$fec_actual = $this->fec_actualGET;
$tipocomp = $this->tipocompGET;


$datos = array("nroComp" => $nroCompEgr,
				"tipoComp" => $tipocomp);

$cabecera = ModeloEgresos::mdlCabeceraNotaJefatura($datos);
$respuesta = ModeloEgresos::mdlDetalleNotaJefatura($datos);



//$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false, false);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(true);

$margen_izquierdo = 8;  // Margen izquierdo en mm
$margen_superior = 55;   // Margen superior en mm
$margen_derecho = 8;    // Margen derecho en mm

$pdf->SetMargins($margen_izquierdo, $margen_superior, $margen_derecho);

$pdf->startPageGroup();

$pdf->AddPage();

// ----------------------------------------------------------------------------
foreach ($cabecera as $key => $itemcb) {

$bloque1 = <<<EOF
	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<th style="font-size:12px; border: 1px solid #666; background-color:#ddd; text-align:center; width:100%;">NOTA DE JEFATURA NRO: 0000{$itemcb['nroing']}</th>
		</tr>
	</table>
	<br>
	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<td style="font-size:10px; border: 1px solid #666; width: 30%;"><strong>FECHA:</strong></td>
			<td style="font-size:10px; border: 1px solid #666; width: 70%;">{$itemcb['fecha']}</td>
		</tr>
		<tr>
			<td style="font-size:10px; border: 1px solid #666; width: 30%;"><strong>RUBRO:</strong></td>
			<td style="font-size:10px; border: 1px solid #666; width: 70%;">{$itemcb['rubro']}</td>
		</tr>
		<tr>
			<td style="font-size:10px; border: 1px solid #666; width: 30%;"><strong>DETALLE DEL EGRESO:</strong></td>
			<td style="font-size:10px; border: 1px solid #666; width: 70%;">{$itemcb['detalle']}</td>
		</tr>
	</table>
	<br>
	<br>
	<table cellspacing="0" cellpadding="2">
		<tr>
			<td style="font-size:10px; width: 100%;"><strong>DESGLOSE DEL GASTO</strong></td>
		</tr>
		<tr>
			<td style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width: 55%;"><strong>DETALLE: PRODUCTO/SERVICIO</strong></td>
			<td style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width: 15%;"><strong>CANTIDAD</strong></td>
			<td style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width: 15%;"><strong>PRECIO UNITARIO</strong></td>
			<td style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width: 15%;"><strong>SUBTOTAL</strong></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');
}

// ----------------------------------------------------------------------------

$total = 0;
foreach ($respuesta as $key => $item) {
$total = $total + $item['subtotal'];
$bloque4 = <<<EOF
		<table style="font-size:10px; padding:3px 10px;">
			<tr>
				<td style="border: 1px solid #666; width: 55%;">{$item['detalleproductos']}</td>
                <td style="border: 1px solid #666; width: 15%;">{$item['cantidad']}</td>
				<td style="border: 1px solid #666; width: 15%;">{$item['punitario']}</td>
				<td style="border: 1px solid #666; width: 15%;">{$item['subtotal']}</td>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ---------------------------------------------------------

$literal = numeroALetras($total);
$bloque2 = <<<EOF
	<table cellspacing="0" cellpadding="2">
		<tr>
			<td style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:right; width: 85%;"><strong>TOTAL:</strong></td>
			<td style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width: 15%;"><strong>$total</strong></td>
		</tr>
		<tr>
			<td style="font-size:10px; text-align:left; width: 10%;">Son :</td>
			<td style="font-size:10px; text-align:center; width: 90%;"><strong>$literal</strong></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

foreach ($cabecera as $key => $itemcb) {

	if($itemcb['nombre'] == "sn"){
		$nombreSoc = "";
	}else{
		$nombreSoc = $itemcb['nombre'];
	}
	if($itemcb['ci'] == "0"){
		$ciSoc = "";
		$firma = "";
	}else{
		$ciSoc = $itemcb['ci'];
		$firma = "FIRMA DEL SOCIO";
	}

	$bloque3 = <<<EOF
		<br>
		<br>
		<table cellspacing="0" cellpadding="2">
			<tr>
				<td style="font-size:10px; width: 20%;"><strong>RESPALDO:</strong></td>
				<td style="font-size:10px; border: 1px solid #666; width: 80%;">{$itemcb['respaldo']}</td>
			</tr>
			<tr>
				<td style="font-size:10px; width: 100%;"><strong>BENEFICIARIO:</strong></td>
			</tr>
			<tr>
				<td style="font-size:10px; border: 1px solid #666; height: 100px; text-align:center; width: 100%;"><br><br><br><br><br><br>$nombreSoc<br>$ciSoc<br>$firma</td>
			</tr>
		</table>
	EOF;
	
	$pdf->writeHTML($bloque3, false, false, false, false, '');
	}

	$bloque5 = <<<EOF
	<br>
	<br>
	<table cellspacing="0" cellpadding="2">
		<tr>
			<td style="font-size:10px; width: 100%;"><strong>COMO CONSTANCIA DE AUTORIZACION FIRMAN JEFATURA EN PLENO:</strong></td>
		</tr>
		<tr>
			<td style="height: 150px; text-align:center; width: 100%;"></td>
		</tr>
	</table>
	EOF;

	$pdf->writeHTML($bloque5, false, false, false, false, '');

	//SALIDA DEL ARCHIVO 

$pdf->Output('ComprobanteNotaJefaturaEgr.pdf', 'I');

}

}

$Reporte = new imprimirComprobantesEgreso();
$Reporte -> nroCompEgrGET = $_GET["nroCompEgr"];
$Reporte -> tipocompGET = $_GET["tipocomp"];
$Reporte -> fec_actualGET = $_GET["fec_actual"];
$Reporte -> impresionNotaJefatura();

function numeroALetras($numero) {
    $formatter = new NumberFormatter("es", NumberFormatter::SPELLOUT);
    
    // Separar la parte entera y la parte decimal
    $partes = explode('.', number_format($numero, 2, '.', ''));
    $parteEntera = $partes[0];
    $parteDecimal = isset($partes[1]) ? $partes[1] : '00';

    // Convertir la parte entera a letras
    $literal = ucfirst($formatter->format($parteEntera));
	$cero = "100";
    // Agregar la parte decimal en formato de centavos
    $moneda = "Bolivianos";
    $literal .= " $parteDecimal/$cero $moneda";

    return $literal;
}

?>