<?php

require_once "../../../modelos/egresos.modelo.php";

class imprimirComprobantesEgreso{

public $nroCompEgrGET;
public $fec_actualGET;
public $tipocompGET;

public function impresionReciboSimpleEgr(){

$nroCompIng = $this->nroCompEgrGET;
$fec_actual = $this->fec_actualGET;
$tipocomp = $this->tipocompGET;


$datos = array("nroComp" => $nroCompIng,
				"tipoComp" => $tipocomp);

$respuesta = ModeloEgresos::mdlComprobanteReciboSimple($datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$margen_izquierdo = 8;  // Margen izquierdo en mm
$margen_superior = 45;   // Margen superior en mm
$margen_derecho = 8;    // Margen derecho en mm

$pdf->SetMargins($margen_izquierdo, $margen_superior, $margen_derecho);

$pdf->startPageGroup();

$pdf->AddPage();

// ----------------------------------------------------------------------------

foreach ($respuesta as $key => $item) {

	$literal = numeroALetras($item['subtotal']);

	$tblvehiculos = <<<EOD
		<br>
	<table cellspacing="0" cellpadding="5" border="1">
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:100%;"><strong>COMPROBANTE DE EGRESO NRO: 0000{$item['nroing']}</strong></th>
		</tr>
	</table>
	<table cellspacing="0" cellpadding="2" border="1">
	
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>CARNET DE IDENTIDAD:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['ci']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>SOCIO:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['nombre']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>NRO DE CELULAR:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['celular']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>RUBRO:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['rubro']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>FECHA:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['fecha']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>DETALLE:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['detalle']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>MONTO:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['subtotal']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>Son:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">$literal</td>
		</tr>
	</table>
	<br>
	<br>
	<br>
	<br>
	<table cellspacing="0" cellpadding="1">
		<tr>
			<td style="font-size:8px; text-align:center; width: 50%;">ENTREGUE CONFORME</td>
			<td style="font-size:8px; text-align:center; width: 50%;">SELLO/FIRMA HACIENDA</td>
		</tr>
		<tr>
			<td style="font-size:8px; text-align:center; width: 50%;">{$item['nombre']}</td>
		</tr>
	</table>
	<div style="font-size:7px; text-align:center; line-height:7px;">
					Sistema Correnet V. 1.0
	</div>
	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($tblvehiculos, true, false, false, false, '');
	
}

// ---------------------------------------------------------

foreach ($respuesta as $key => $item) {

	$tblcopia = <<<EOD
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
		<br>
	<table cellspacing="0" cellpadding="5" border="1">
		<tr>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:100%;"><strong>COMPROBANTE DE EGRESO NRO: 0000{$item['nroing']}</strong></th>
		</tr>
	</table>
	<table cellspacing="0" cellpadding="2" border="1">
	
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>CARNET DE IDENTIDAD:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['ci']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>SOCIO:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['nombre']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>NRO DE CELULAR:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['celular']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>RUBRO:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['rubro']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>FECHA:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['fecha']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>DETALLE:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['detalle']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>MONTO:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">{$item['subtotal']}</td>
		</tr>
		<tr>
			<td style="font-size:8px; border: 1px solid #666; width: 30%;"><strong>Son:</strong></td>
			<td style="font-size:8px; border: 1px solid #666; width: 70%;">$literal</td>
		</tr>
	</table>
	<br>
	<br>
	<br>
	<br>
	<table cellspacing="0" cellpadding="2">
		<tr>
			<td style="font-size:8px; text-align:center; width: 50%;">ENTREGUE CONFORME</td>
			<td style="font-size:8px; text-align:center; width: 50%;">SELLO/FIRMA HACIENDA</td>
		</tr>
		<tr>
			<td style="font-size:8px; text-align:center; width: 50%;">{$item['nombre']}</td>
		</tr>
	</table>
	<div style="font-size:7px; text-align:center; line-height:7px;">
					Sistema Correnet V. 2.0
	</div>
	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($tblcopia, true, false, false, false, '');
	
}


//SALIDA DEL ARCHIVO 

$pdf->Output('ComprobanteSimpleEgr.pdf', 'I');

}

}

$Reporte = new imprimirComprobantesEgreso();
$Reporte -> nroCompEgrGET = $_GET["nroCompEgr"];
$Reporte -> tipocompGET = $_GET["tipocomp"];
$Reporte -> fec_actualGET = $_GET["fec_actual"];
$Reporte -> impresionReciboSimpleEgr();

function numeroALetras($numero) {
    $formatter = new NumberFormatter("es", NumberFormatter::SPELLOUT);
    
    // Separar la parte entera y la parte decimal
    $partes = explode('.', number_format($numero, 2, '.', ''));
    $parteEntera = $partes[0];
    $parteDecimal = isset($partes[1]) ? $partes[1] : '00';

    // Convertir la parte entera a letras
    $literal = ucfirst($formatter->format($parteEntera));
	$cero = "100";
    // Agregar la parte decimal en formato de centavos
    $moneda = "Bolivianos";
    $literal .= " $parteDecimal/$cero $moneda";

    return $literal;
}

?>