<?php

require_once "../../../modelos/reportesdeudas.modelo.php";

class imprimirReporteApuestas{

public $rEquipo1GET;
public $rRes1GET;
public $rEquipo2GET;
public $rRes2GET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$REquipo1 = $this->rEquipo1GET;
$RRes1 = $this->rRes1GET;
$REquipo2 = $this->rEquipo2GET;
$RRes2 = $this->rRes2GET;

$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;
$tabla = "tx_apuestas";

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("Requipo1" => $REquipo1,
"Rres1" => $RRes1,
"Requipo2" => $REquipo2,
"Rres2" => $RRes2,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuestadeudas = ModeloReporteDeudas::mdlMostrarApuestasreporte($tabla,$datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logoinicio.png"></td>
			<td style="background-color:white; width:350px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Apuesto por Ti V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px; color:blue">
					REPORTE DE APUESTAS
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------
$EncabezadoDeuda = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
				<br>
			    <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">#</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">EQUIPO 1</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">RESUL 1</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">EQUIPO 2</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">RESUL 2</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">FECHA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">MONTO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">USUARIO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($EncabezadoDeuda, false, false, false, false, '');

// ----------------------------------------------------------------------------

$num = 0;
$totales = 0;

foreach ($respuestadeudas as $key => $item) {
$num = $num + 1;
$totales += $item['monto'];
$bloque3 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:8%;">$num</td>
				<td style="border: 1px solid #666; text-align:center; width:15%;">{$item['Equipo1']}</td>
                <td style="border: 1px solid #666; text-align:center; width:10%;">{$item['Res1']}</td>
				<td style="border: 1px solid #666; text-align:center; width:15%;">{$item['Equipo2']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['Res2']}</td>
				<td style="border: 1px solid #666; text-align:center; width:15%;">{$item['Fecha']}</td>
                <td style="border: 1px solid #666; text-align:center; width:15%;">{$item['monto']}</td>
				<td style="border: 1px solid #666; text-align:center; width:15%;">{$item['usuario']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotalIng = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:73%;"><strong>Total Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:15%;"><strong>$totales</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotalIng, false, false, false, false, '');

//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteGeneralApuestas.pdf', 'I');

}

}

$Reporte = new imprimirReporteApuestas();
$Reporte -> rEquipo1GET = $_GET["rEquipo1"];
$Reporte -> rRes1GET = $_GET["rRes1"];
$Reporte -> rEquipo2GET = $_GET["rEquipo2"];
$Reporte -> rRes2GET = $_GET["rRes2"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>