<?php

require_once "../../../modelos/arqueo.modelo.php";

class imprimirArqueo{

public $codaGET;
public $usuarioGET;

public function traerImpresionReporte(){

$coda = $this->codaGET;
$usuarionomb = $this->usuarioGET;
$tabla = "tx_arqueo";
date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("repcoda" => $coda);
$respuestaarq = ModeloArqueo::MdlReporteArqueo($datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$margen_izquierdo = 8;  // Margen izquierdo en mm
$margen_superior = 55;   // Margen superior en mm
$margen_derecho = 8;    // Margen derecho en mm

$pdf->SetMargins($margen_izquierdo, $margen_superior, $margen_derecho);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="background-color:white; width:550px">
				<div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2025 V.2 - Hora impresion: $horaActual
                </div>
				<div style="font-size:10px; text-align:center; line-height:15px">
					ARQUEO DE CAJA
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------


// Calcular la posición X centrada
$xCentered = 65;

// Centrar la primera tabla
$pdf->SetX($xCentered);

foreach ($respuestaarq as $key => $item) {

	$tot200 = number_format($item['b200'] * 200,2);
	$tot100 = number_format($item['b100'] * 100,2);
	$tot50 = number_format($item['b50'] * 50,2);
	$tot20 = number_format($item['b20'] * 20,2);
	$tot10 = number_format($item['b10'] * 10,2);

	$tot5 = number_format($item['m5'] * 5,2);
	$tot2 = number_format($item['m2'] * 2,2);
	$tot1 = number_format($item['m1'] * 1,2);
	$tot05 = number_format($item['m05'] * 0.5,2);
	$tot02 = number_format($item['m02'] * 0.2,2);
	$tot01 = number_format($item['m01'] * 0.1,2);
	$total = number_format($item['totalmon'] + $item['totalbil'],2);
	$totalbilletes = number_format($item['totalbil'],2);
	$totalmonedas = number_format($item['totalmon'],2);
	$arqueo = <<<EOD

	<table cellspacing="0" cellpadding="3" border="1" style="margin: 0 auto;">
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:60%;">FECHA : {$item['fecha']} HORA: {$item['hora']}</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:60%;">Secretario de Hacienda : $usuarionomb </th>
		</tr>
	</table>
	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:left; width:60%;">Recuento de Billetes :</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">Corte Bs.</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">Cantidad</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">Monto</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">200</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['b200']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot200</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">100</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['b100']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot100</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">50</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['b50']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot50</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">20</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['b20']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot20</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">10</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['b10']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot10</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:40%;">Total Billetes</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">$totalbilletes</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:left; width:60%;">Recuento de Monedas :</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">Corte Bs.</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">Cantidad</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">Monto</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">5</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['m5']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot5</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">2</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['m2']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot2</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">1</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['m1']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot1</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">0.5</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['m05']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot05</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">0.2</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['m02']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot02</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">0.1</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">{$item['m01']}</th>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:20%;">$tot01</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:40%;">Total Monedas</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">$totalmonedas</th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; text-align:center; width:60%;"></th>
		</tr>
		<tr>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:40%;">Suma Total Billetes y Monedas</th>
			<th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">$total</th>
		</tr>
	</table>
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;"></th>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;"></th>
		</tr>
		<tr>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;"></th>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;"></th>
		</tr>
		<tr>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;"></th>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;"></th>
		</tr>
		<tr>
			<th style="font-size:9px; solid #666; text-align:center; width:30%;">FIRMA</th>
			<th style="font-size:9px; solid #666; text-align:center; width:30%;">FIRMA</th>
		</tr>
		<tr>
			<th style="font-size:9px; solid #666; text-align:center; width:30%;">$usuarionomb</th>
			<th style="font-size:9px; solid #666; text-align:center; width:30%;">{$item['encarqueo']}</th>
		</tr>
		<tr>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;">SECRETARIO HACIENDA</th>
			<th style="font-size:8px; solid #666; text-align:center; width:30%;">RESPONSABLE ARQUEO</th>
		</tr>
		<tr>
			<th style="font-size:7px; solid #666; text-align:center; width:60%;">Sistema Correnet V. 1.0</th>
		</tr>
	</table>

	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($arqueo, false, false, false, false, '');
	
}




// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ArqueoCaja.pdf', 'I');

}

}

$Reporte = new imprimirArqueo();
$Reporte -> codaGET = $_GET["coda"];
$Reporte -> usuarioGET = $_GET["usuario"];
$Reporte -> traerImpresionReporte();

?>