<?php

require_once "../../../modelos/arqueo.modelo.php";

class imprimirCierreDiario{

public $codcdGET;
public $fechacieGET;

public function traerImpresionReporte(){

$codcd = $this->codcdGET;
$fechacie = $this->fechacieGET;

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("repcoda" => $codcd);
$respuestaIng = ModeloArqueo::MdlRecuperaIngresosRep($fechacie);
$respuestaEgr = ModeloArqueo::MdlRecuperaEgresosRep($fechacie);
$respuestacierre = ModeloArqueo::MdlReporteCierre($codcd);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
 
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$margen_izquierdo = 8;  // Margen izquierdo en mm
$margen_superior = 55;   // Margen superior en mm
$margen_derecho = 8;    // Margen derecho en mm

$pdf->SetMargins($margen_izquierdo, $margen_superior, $margen_derecho);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="background-color:white; width:550px">
                <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:10px; text-align:center; line-height:15px">
					CIERRE DIARIO DE CAJA
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

foreach ($respuestacierre as $key => $item) {

	$saldoingegr = number_format($item['saldoingegr'],2);
	$salanterior = number_format($item['saldoanterior'],2);
	$saldocaja = number_format($item['saldocaja'],2);
	$saldoarqueo = number_format($item['saldoarqueo'],2);
	$deudapen = number_format($item['deudaspen'],2);
	$deudaven = number_format($item['deudasven'],2);

	$sobrantefaltante = number_format($item['saldoarqueo'] - $item['saldocaja'],2);
	$fecha = DateTime::createFromFormat('Y-m-d', $item['fecha'])->format('d/m/Y');
	$cierre = <<<EOD

	<table cellspacing="0" cellpadding="3" border="0">
		<tr>
			<th style="font-size:8px; solid #666; text-align:center; width:100%;">A FECHA : $fecha HORA: {$item['hora']}</th>
		</tr>
		<tr>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:100%;">RESUMEN DE MOVIMIENTOS DEL DIA</th>
		</tr>
	</table>
	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:55%;">RUBRO</th>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">CANTIDAD</th>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">INGRESOS</th>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">EGRESOS</th>
		</tr>
	</table>
	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($cierre, false, false, false, false, '');
	
}

// ----------------------------------------------------------------------------

$totcantidad = 0;
$totalsumingre = 0;
foreach ($respuestaIng as $key => $item) {

$totcantidad += $item['cantidad'];
$totalsumingre += $item['totingresos'];
$ingresos = number_format($item['totingresos'],2);
	$ingresos = <<<EOD

	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<td style="font-size:8px; border: 1px solid #666; text-align:left; width:55%;">{$item['rubro']}</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">{$item['cantidad']}</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">$ingresos</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;"></td>
		</tr>
	</table>
	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($ingresos, false, false, false, false, '');
}

// ----------------------------------------------------------------------------

$totcantidadeg = 0;
$totalsumegre = 0;
foreach ($respuestaEgr as $key => $item) {

$totcantidadeg += $item['cantidad'];
$totalsumegre += $item['totegresos'];
$egresos = number_format($item['totegresos'],2);
	$egresos= <<<EOD

	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<td style="font-size:8px; border: 1px solid #666; text-align:left; width:55%;">{$item['rubro']}</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">{$item['cantidad']}</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;"></td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">$egresos</td>
		</tr>
	</table>
	EOD;
	
	// Imprimir tabla de datos del propietario
	$pdf->writeHTML($egresos, false, false, false, false, '');
}

// ------------------------------------------------------------------------------------------------------

$totsuming = number_format($totalsumingre,2);
$totsumegr = number_format($totalsumegre,2);
$totalcantidades = $totcantidad + $totcantidadeg;
$bloqueSubTotal = <<<EOF
	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
            <td style="font-size:8px; border: 1px solid #666; text-align:center; width:55%;">SUBTOTALES</td>
            <td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">$totalcantidades</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">$totsuming</td>
			<td style="font-size:8px; border: 1px solid #666; text-align:center; width:15%;">$totsumegr</td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueSubTotal, false, false, false, false, '');


// ----------------------------------------------------------------------------

$date = new DateTime($fechacie);
$date->modify('-1 day'); 
$fechaanterior = $date->format('d/m/Y'); 

$bloqueSaldos = <<<EOF
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
            <th style="font-size:8px; solid #666; text-align:left; width:75%;">SALDO DEL DIA (TOTAL INGRESOS - TOTAL EGRESOS)</th>
            <th style="font-size:8px; solid #666; text-align:center; width:25%;">$saldoingegr</th>
		</tr>
		<tr>
            <th style="font-size:8px; solid #666; text-align:left; width:75%;">Saldo del dia anterior $fechaanterior</th>
            <th style="font-size:8px; solid #666; text-align:center; width:25%;">$salanterior</th>
		</tr>
		<tr>
            <th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:left; width:75%;">TOTAL DE SALDO EN CAJA</th>
            <th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:25%;">$saldocaja</th>
		</tr>
		<tr>
            <th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:left; width:75%;">SALDO SEGUN ARQUEO DE CAJA BILLETES Y MONEDAS</th>
            <th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:25%;">$saldoarqueo</th>
		</tr>
		<tr>
            <th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:left; width:75%;">SOBRANTE / FALTANTE</th>
            <th style="font-size:10px; border: 1px solid #666; background-color:#ddd; text-align:center; width:25%; color:red">$sobrantefaltante</th>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueSaldos, false, false, false, false, '');

// ---------------------------------------------------------

$bloquedeudas = <<<EOF
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
            <th style="font-size:8px; solid #666; text-align:left; width:75%;">TOTAL DEUDAS ACUMULADAS PENDIENTES</th>
            <th style="font-size:8px; solid #666; text-align:center; width:25%;">$deudapen</th>
		</tr>
		<tr>
            <th style="font-size:8px; solid #666; text-align:left; width:75%;">TOTAL DEUDAS ACUMULADAS VENCIDAS</th>
            <th style="font-size:8px; solid #666; text-align:center; width:25%;">$deudaven</th>
		</tr>
	</table>
	<br>
	<br>
	<br>
	<br>
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<th style="font-size:8px; solid #666; text-align:center; width:50%;">FIRMA SECRETARIO HACIENDA</th>
			<th style="font-size:8px; solid #666; text-align:center; width:50%;">FIRMA RESPONSABLE ARQUEO</th>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloquedeudas, false, false, false, false, '');
//SALIDA DEL ARCHIVO 

$pdf->Output('ArqueoCaja.pdf', 'I');

}

}

$Reporte = new imprimirCierreDiario();
$Reporte -> codcdGET = $_GET["codcd"];
$Reporte -> fechacieGET = $_GET["fechacierre"];
$Reporte -> traerImpresionReporte();

?>