<?php

require_once "../../../modelos/reportesdeudas.modelo.php";

class imprimirReporteDeudaGeneral{

public $estadodeGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$estadode = $this->estadodeGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;
$tabla = "tx_deudas";

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("repestadode" => $estadode,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuestadeudas = ModeloReporteDeudas::mdlMostrarDeudaGeneralEstado($tabla,$datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:350px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px; color:blue">
					REPORTE GENERAL
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------
$EncabezadoDeuda = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
				<br>
			    <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">ID_DE</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">FECHA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:14%;">CONCEPTO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">DESCRIPCION</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:13%;">SOCIO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:9%;">TOTAL</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:12%;">ESTADO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($EncabezadoDeuda, false, false, false, false, '');

// ----------------------------------------------------------------------------

$num = 0;
$totales = 0;

foreach ($respuestadeudas as $key => $item) {
$num = $num + 1;
$totales += $item['total'];
$bloque3 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:8%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['cod_deuda']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['fechareg']}</td>
                <td style="border: 1px solid #666; text-align:center; width:14%;">{$item['rubro']}</td>
				<td style="border: 1px solid #666; text-align:center; width:20%;">{$item['descripcion']}</td>
				<td style="border: 1px solid #666; text-align:center; width:13%;">{$item['nombre_completo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:9%;">{$item['total']}</td>
                <td style="border: 1px solid #666; text-align:center; width:12%;">{$item['estado']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotal = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:73%;"><strong>Total Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:9%;"><strong>$totales</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotal, false, false, false, false, '');

//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteGeneralDeudas.pdf', 'I');

}

}

$Reporte = new imprimirReporteDeudaGeneral();
$Reporte -> estadodeGET = $_GET["estadode"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>