<?php

require_once "../../../modelos/reportesdeudas.modelo.php";

class imprimirReporteDeudaItem{

public $rubrodeGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$rubrode = $this->rubrodeGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;
$tablaig = "tx_deudas";

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("reprubrode" => $rubrode,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuestadeudas = ModeloReporteDeudas::mdlMostrarReporteDeudasRubro($tablaig,$datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:550px">
                <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px; color:blue">
					REPORTE DEUDAS POR RUBRO
					<br>
					Del: $FechaIni Al: $FechaFin
					<br>
					RUBRO: $rubrode
				</div>
				<div style="font-size:7px; text-align:center; line-height:7px;">
					Sistema Correnet V. 1.0
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------
$bloqueEncabezado = <<<EOF
        <table style="font-size:9px; padding:3px 9px;">
            <tr>
				<br>
			    <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:6%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:9%;">FECHA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">CI</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:27%;">NOMBRE</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:32%;">DESCRIPCION</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">ESTADO</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">MONTO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotalIng = 0;
$num = 0;

foreach ($respuestadeudas as $key => $item) {
$sumaTotalIng += $item['total'];
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:9px; padding:3px 9px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:6%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:9%;">{$item['fechareg']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['ci']}</td>
				<td style="border: 1px solid #666; text-align:center; width:27%;">{$item['nombre_completo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:32%;">{$item['descripcion']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['estado']}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['total']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotalIng = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:92%;"><strong>Total Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:8%;"><strong>$sumaTotalIng</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotalIng, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteRubroDeudas.pdf', 'I');

}

}

$Reporte = new imprimirReporteDeudaItem();
$Reporte -> rubrodeGET = $_GET["rubrode"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>