<?php

require_once "../../../modelos/reportesmensual.modelo.php";

class imprimirReporteExtractoSocio{

public $sociomenGET;
public $gestionGET;
public $fecfinGET;

public function traerImpresionReporte(){

$sociomen = $this->sociomenGET;
$gestion = $this->gestionGET;
$FechaFin = $this->fecfinGET;

$datos = array("repsociomen" => $sociomen,
			   "repgestion" => $gestion);
$respuestaSocio = ModeloReporteMensual::MdlMostrarDatosSocio($sociomen);
$respuestaMeses = ModeloReporteMensual::mdlMostrarMeses($datos);
$respuestavarios = ModeloReporteMensual::mdlMostrarVarios($datos);

require_once('tcpdf_include.php');

//$ancho = 110; // Ancho en milímetros (ejemplo: 210mm para A4)
//$alto = 280;  // Alto en milímetros (ejemplo: 150mm personalizado)

//$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false);
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$margen_izquierdo = 2;  // Margen izquierdo en mm
$margen_superior = 55;   // Margen superior en mm
$margen_derecho = 2;    // Margen derecho en mm
$margen_inferior = 2;

$pdf->SetMargins($margen_izquierdo, $margen_superior, $margen_derecho);

$margen_inferior = 2; // Margen inferior en mm
$pdf->SetAutoPageBreak(true, $margen_inferior);

$pdf->startPageGroup();

$pdf->AddPage();

// Calcular la posición X centrada
$xCentered = 55;

// Centrar la primera tabla
$pdf->SetX($xCentered);

$fechaActual = date('d-m-Y');
$bloque1 = <<<EOF
	<table>
		<tr>	
			<td style="width:300px"><img src="images/extractoCab.png"></td>
		</tr>
		<tr>
			<td style="background-color:white; width:300px">
            <div style="font-size:9px; text-align:center; line-height:5px; color:blue; font-weight:bold;">
			Fecha de Emision: $fechaActual
			<br>
			<br>
            </div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

foreach ($respuestaSocio as $key => $item) {
	if($item['tp'] == "PRO"){
		$tipo = "PROPIETARIO";
	}
	if($item['tp'] == "ASA"){
		$tipo = "ASALARIADO";
	}
	if($item['tp'] == "INS"){
		$tipo = "AUTORIDAD";
	}
	$sociomen = <<<EOD
	<table cellspacing="0" cellpadding="2" border="1">
		<tr>
			<td style="font-size:8px; border:none; width: 14%;">SOCIO:</td>
			<td style="font-size:8px; border:none; width: 55%;"><strong>{$item['nombre_completo']}</strong></td>
		</tr>
		<tr>
			<td style="font-size:8px; border:none; width: 14%;">CONDICION:</td>
			<td style="font-size:8px; border:none; width: 55%;"><strong>$tipo</strong></td>
		</tr>
		<tr>
			<td style="font-size:8px; border:none; width: 14%;">PLACA:</td>
			<td style="font-size:8px; border:none; width: 55%;"><strong>{$item['placa']}</strong></td>
		</tr>
		<tr>
			<td style="font-size:8px; border:none; width: 14%;">CELULAR:</td>
			<td style="font-size:8px; border:none; width: 55%;"><strong>{$item['celular']}</strong></td>
		</tr>
	</table>
	EOD;
	$pdf->writeHTML($sociomen, false, false, false, false, '');
}

// ----------------------------------------------------------------------------
//$anioActual = date('Y');
$EncabezadoMeses = <<<EOF
    <table cellspacing="0" cellpadding="2" style="margin: 0; padding: 0;">
		<tr>
			<th style="font-size:9px; border: 1px solid #666; background-color:#ddd; text-align:center; width:69%;">GESTION $gestion</th>
		</tr>
        <tr>
                <th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">MES</th>
				<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:13%;">FECHA PAGO</th>
                <th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">NRO RECIBO</th>
				<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:11%;">MONTO</th>
				<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">OBSERVACIONES</th>
        </tr>
	</table>
EOF;
$pdf->writeHTML($EncabezadoMeses, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotal = 0;
//$num = 0;
foreach ($respuestaMeses as $key => $item) {
$sumaTotal += $item['monto'];
//$num = $num + 1;
$bloque2 = <<<EOF
		<table style="font-size:7px; padding:2px 7px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:15%;">{$item['rubro']}</td>
                <td style="border: 1px solid #666; text-align:center; width:13%;">{$item['fechapago']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['nrorecibo']}</td>
                <td style="border: 1px solid #666; text-align:center; width:11%;">{$item['monto']}</td>
				<td style="border: 1px solid #666; text-align:center; width:20%;">{$item['observaciones']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$saldo = 1200 - $sumaTotal;
$bloquemeses = <<<EOF
	<table style="padding:2px 3px;">
		<tr>
            <td style="font-size:7px; solid #666; text-align:right;width:38%;"><strong>MONTO APORTES MENSUALES</strong></td>
            <td style="font-size:8px; border: 0px solid #666; color:blue; text-align:center;width:11%;"><strong>Bs. $sumaTotal</strong></td> 
		</tr>
		<tr>
            <td style="font-size:7px; solid #666; text-align:right;width:38%;">SALDO PENDIENTE</td>
            <td style="font-size:8px; border: 0px solid #666; color:red; text-align:center;width:11%;"><strong>Bs. $saldo</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloquemeses, false, false, false, false, '');

// ------------------------------------------------------------------------------------------------------

$Encabezadovarios = <<<EOF
    <table cellpadding="3">
		<tr>
			<th style="font-size:8px; border: 1px solid #666; background-color:#ddd; text-align:center; width:69%;">AYUDAS Y OTROS APORTES APROBADOS</th>
		</tr>
        <tr>
                <th style="font-size:7px; border: 1px solid #666; background-color:#ddd; text-align:center; width:38%;">CONCEPTO</th>
				<th style="font-size:7px; border: 1px solid #666; background-color:#ddd; text-align:center; width:11%;">MONTO</th>
				<th style="font-size:7px; border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">OBSERVACIONES</th>
        </tr>
	</table>
EOF;
$pdf->writeHTML($Encabezadovarios, false, false, false, false, '');

// ------------------------------------------------------------------------------------------------------

$sumaTotalv = 0;
//$num = 0;
foreach ($respuestavarios as $key => $item) {
$sumaTotalv += $item['monto'];
//$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:7px; padding:2px 7px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:38%;">{$item['rubro']}</td>
                <td style="border: 1px solid #666; text-align:center; width:11%;">{$item['monto']}</td>
				<td style="border: 1px solid #666; text-align:center; width:20%;">{$item['observaciones']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ---------------------------------------------------------

$totalvarios = <<<EOF
	<table style="padding:2px 2px;">
		<tr>
            <td style="font-size:7px; solid #666; text-align:right;width:38%;"><strong>MONTO EN AYUDAS Y OTROS APORTES</strong></td>
            <td style="font-size:8px; border: 0px solid #666; color:blue; text-align:center;width:11%;"><strong>Bs. $sumaTotalv</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($totalvarios, false, false, false, false, '');

// ---------------------------------------------------------


$totales = $sumaTotal + $sumaTotalv;
$literal = numeroALetras($totales);
$total = <<<EOF
	<table style="padding:2px 2px;">
		<tr>
            <td style="font-size:7px; border: 1px solid #666; background-color:#ddd; text-align:center; width:38%;"><strong>MONTO TOTAL DEPOSITADO EN APORTES MENSUALES Y AYUDAS EN LA GESTION</strong></td>
            <td style="font-size:8px; border: 1px solid #666; background-color:#ddd; color:green; text-align:center;width:31%;"><strong>Bs. $totales <br> $literal</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($total, false, false, false, false, '');

// ---------------------------------------------------------

$nota = <<<EOF
	<table style="padding:2px 4px;">
		<tr>
            <td style="font-size:6px; solid #666; text-align:center; width:69%;"><strong><em>El presente no tiene validez sin el sello y firma de Secretaria de hacienda o si en su caso en el presente documento existieran borrones y/o tachaduras</em></strong></td>
		</tr>
	</table>
    <table style="padding:2px 4px;">
	    <tr>
           	<td style="font-size:7px; solid #666; text-align:center; width:38%;"></td>
            <td style="font-size:8px; solid #666; text-align:center;width:31%;"></td> 
		</tr>
		<tr>
           	<td style="font-size:7px; solid #666; text-align:center; width:38%;"></td>
            <td style="font-size:8px; solid #666; text-align:center;width:31%;"></td> 
		</tr>
		<tr>
           	<td style="font-size:7px; solid #666; text-align:center; width:38%;">FIRMA SOCIO</td>
            <td style="font-size:8px; solid #666; text-align:center;width:31%;">SELLO HACIENDA</td> 
		</tr>
		<tr>
            <td style="font-size:7px; solid #666; text-align:center;width:69%;">Sistema Correnet V. 1.0</td> 
		</tr>
	</table>

EOF;

$pdf->writeHTML($nota, false, false, false, false, '');

// ------------------------------------------------------------------------------------------------------

//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteSocioDeudas.pdf', 'I');

}

}

$Reporte = new imprimirReporteExtractoSocio();
$Reporte -> sociomenGET = $_GET["sociomen"];
$Reporte -> gestionGET = $_GET["gestion"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

function numeroALetras($numero) {
    $formatter = new NumberFormatter("es", NumberFormatter::SPELLOUT);
    
    // Separar la parte entera y la parte decimal
    $partes = explode('.', number_format($numero, 2, '.', ''));
    $parteEntera = $partes[0];
    $parteDecimal = isset($partes[1]) ? $partes[1] : '00';

    // Convertir la parte entera a letras
    $literal = ucfirst($formatter->format($parteEntera));
	$cero = "00";
    // Agregar la parte decimal en formato de centavos
    $moneda = "Bolivianos";
    $literal .= " $cero/$parteDecimal $moneda";

    return $literal;
}

?>