<?php

require_once "../../../modelos/reportesingegre.modelo.php";

class imprimirReporteGeneral{

public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;
$tablaig = "tx_ingresos";
$tablaeg = "tx_egresos";
$tablamensuales = "tx_mensualdetalle";

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);

$respuestasaldoanterior = ModeloIngresosEgresos::mdlObtieneSaldoAnt($datos);
$respuestaing = ModeloIngresosEgresos::mdlMostrarReporteGeneral2($tablaig,$datos);
$respuestaegr = ModeloIngresosEgresos::mdlMostrarReporteGeneral2($tablaeg,$datos);
$respuestaingmensuales = ModeloIngresosEgresos::mdlMostrarReporteGeneralmensuales($tablamensuales,$datos);

$resEgresosGeneral = ModeloIngresosEgresos::mdlMostrarReporteEgresosGeneral($tablaeg, $datos);

$resIngresosGeneral = ModeloIngresosEgresos::mdlMostrarReporteIngresosGeneral($tablaig, $datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION,PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:350px">
                                <div style="font-size:7px; text-align:center;">
                                Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                                </div>
				<div style="font-size:11px; text-align:center; line-height:15px;">
                                        TRUFI CORRECAMINOS 408 - 453 - 479 - 460
                                        <br>
					REPORTE GENERAL DE RESULTADOS
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');


// ----------------------------------------------------------------------------
foreach ($respuestasaldoanterior as $key => $item) {
    $SaldoAnterior = isset($item['saldoanterior']) ? $item['saldoanterior'] : 0;
}

$SaldoPerdioAnterior = number_format((float)$SaldoAnterior, 2, '.', ','); 

foreach ($respuestaegr as $key => $item) {
        $totalegresos = isset($item['total']) ? $item['total'] : 0;    
}   

$totalegresos_for = number_format((float)$totalegresos, 2, '.', ','); 

foreach ($respuestaingmensuales as $key => $item) {
        $totalmensuales = isset($item['total']) ? $item['total'] : 0;
}

foreach ($respuestaing as $key => $item) {
        $totalegingresos = isset($item['total']) ? $item['total'] : 0;
}
$totalingymensual = $totalegingresos + $totalmensuales;  
$totaling = $totalegingresos + $SaldoAnterior + $totalmensuales;  


$totalingresos = number_format((float)$totalingymensual, 2, '.', ',');   
$totalingresos_for = number_format((float)$totaling, 2, '.', ',');  

$resges = $totaling - $totalegresos;
$resultadogestion = number_format((float)$resges, 2, '.', ',');  

$resu = str_replace(',', '', $resultadogestion); // Eliminar comas
$resu = floatval($resu); // Convertir a flotante

// Llamar a la función numeroALetras con el número convertido
$literal = numeroALetras($resu);

$fecha = new DateTime($FechaIni);
$fecha->modify('-1 day');
$FechaAnterior = $fecha->format('Y-m-d');

$bloqueEncabezadoIng = <<<EOF
        <table style="font-size:10px; width:100%; border-collapse:collapse; padding:5px;">
                <!-- Encabezado de Ingresos y Egresos -->
                <tr>
                <td style="width:60%;"></td>
                <td style="width:20%; text-align:center; font-weight:bold;">INGRESOS</td>
                <td style="width:20%; text-align:center; font-weight:bold;">EGRESOS</td>
                </tr>
                <!-- Saldo Anterior al Periodo -->
                <tr>
                <td style="border: 1px solid #000; padding:5px;">SALDO ANTERIOR AL PERIODO $FechaAnterior</td>
                <td style="border: 1px solid #000; text-align:right; padding:5px;">$SaldoPerdioAnterior</td>
                <td style="border: 1px solid #000;"></td>
                </tr>
                <!-- Total de Ingresos -->
                <tr>
                <td style="border: 1px solid #000; padding:5px;">TOTAL DE INGRESOS DE LA GESTIÓN</td>
                <td style="border: 1px solid #000; text-align:right; padding:5px;">$totalingresos</td>
                <td style="border: 1px solid #000;"></td>
                </tr>
                <!-- Total de Egresos -->
                <tr>
                <td style="border: 1px solid #000; padding:5px;">TOTAL DE EGRESOS DE LA GESTIÓN</td>
                <td style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; text-align:right; padding:5px;">$totalegresos_for</td>
                </tr>
                <!-- Totales -->
                <tr>
                <td style="border: 1px solid #000; padding:5px; font-weight:bold;">TOTALES</td>
                <td style="border: 1px solid #000; text-align:right; font-weight:bold; padding:5px;">$totalingresos_for</td>
                <td style="border: 1px solid #000; text-align:right; font-weight:bold; padding:5px;">$totalegresos_for</td>
                </tr>
        </table>
EOF;
$pdf->writeHTML($bloqueEncabezadoIng, false, false, false, false, '');

// ---------------------------------------------------------

$bloqueResultados = <<<EOF
<br>
<br>
<table style="font-size:10px; width:100%; border-collapse:collapse; padding:5px;">
   <tr>
     <td style="border: 1px solid #000; padding:5px; font-weight:bold; text-align:center; width:50%;">
     RESULTADO DE LA GESTIÓN <br> (TOTAL INGRESOS - TOTAL EGRESOS)
     </td>
     <td style="border: 1px solid #000; text-align:center; font-weight:bold; padding:5px; width:50%;">
     $resultadogestion
     <br>
     Son: $literal
     </td>
   </tr>
</table>
EOF;
$pdf->writeHTML($bloqueResultados, false, false, false, false, '');

// ---------------------------------------------------------

$bloquePiePagina = <<<EOF
<table style="font-size:8px; padding:10px 15px; width:100%;">
    <tr>
        <td colspan="2" style="text-align:left; padding-bottom:15px;">
            Como constancia de entrega de los fondos, firmamos al pie del presente:
        </td>
    </tr>
    <br>
    <br>
    <tr>
        <td style="text-align:center; width:50%; padding:10px;">
            <b>FIRMA DE ENTREGA</b><br>
            Nombre: ..................................................<br>
            C.I.: ....................................................<br>
            <b>STRIO. DE HACIENDA SALIENTE</b>
        </td>
        <td style="text-align:center; width:50%; padding:10px;">
            <b>FIRMA DE RECEPCION</b><br>
            Nombre: ..................................................<br>
            C.I.: ....................................................<br>
            <b>STRIO. DE HACIENDA ENTRANTE</b>
        </td>
    </tr>
    <tr>
        <td colspan="2" style="text-align:left; padding-top:15px;">
            <b>FIRMAS DE RESPALDO (JEFATURA SALIENTE Y JEFATURA ENTRANTE):</b>
        </td>
    </tr>
</table>
EOF;

$pdf->writeHTML($bloquePiePagina, false, false, false, false, '');

// ---------------------PAGINA DE EGRESOS------------------------------------

$pdf->AddPage();

$bloqueEncEgresos = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:350px">
                                <div style="font-size:7px; text-align:center;">
                                Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                                </div>
				<div style="font-size:11px; text-align:center; line-height:15px;">
                                        TRUFI CORRECAMINOS 408 - 453 - 479 - 460
                                        <br>
					REPORTE GENERAL DE EGRESOS
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueEncEgresos, false, false, false, false, '');

// -----------------------------------------------------------------------

$bloqueEncTablaEgresos = <<<EOF
        <table style="font-size:9px; padding:3px 9px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">Nro</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:70%;">RUBRO</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">MONTO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncTablaEgresos, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotalEgr = 0;
$num = 0;

foreach ($resEgresosGeneral as $key => $item) {
    $stotaeg = isset($item['subtotal']) ? $item['subtotal'] : 0;
$montoegre = number_format((float)$stotaeg, 2, '.', ',');      
$sumaTotalEgr += $item['subtotal'];
$num = $num + 1;
$bloqDetEgresos = <<<EOF
		<table style="font-size:9px; padding:3px 9px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:10%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:70%;">{$item['rubro']}</td>
                <td style="border: 1px solid #666; text-align:center; width:20%;">$montoegre</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloqDetEgresos, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------
$egf = str_replace(',', '', $sumaTotalEgr); 
$egf = floatval($egf); 
$sumaTotalEgresos = number_format($egf, 2, '.', ',');

$literalegresos = numeroALetras($egf);

$bloqTotalEg = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; background-color:#ddd; text-align:right;width:80%;"><strong>Total Egresos Bs </strong></td>
            <td style="border: 1px solid #666; background-color:#ddd; text-align:center;width:20%;"><strong>$sumaTotalEgresos</strong></td> 
		</tr>
		<tr>
		    <td style="border: 1px solid #666; background-color:#ddd; text-align:center;width:100%;"><strong>Son: $literalegresos</strong></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqTotalEg, false, false, false, false, '');

// ---------------------PAGINA DE INGRESOS------------------------------------

$pdf->AddPage();

$bloqueEncIngresos = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:350px">
                                <div style="font-size:7px; text-align:center;">
                                Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                                </div>
				<div style="font-size:11px; text-align:center; line-height:15px;">
                                        TRUFI CORRECAMINOS 408 - 453 - 479 - 460
                                        <br>
					REPORTE GENERAL DE INGRESOS
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>
EOF;



$pdf->writeHTML($bloqueEncIngresos, false, false, false, false, '');

// ---------------------------------------------------------

$bloqueEncTablaIngresos = <<<EOF
        <table style="font-size:9px; padding:3px 9px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">Nro</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:70%;">RUBRO</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:20%;">MONTO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncTablaIngresos, false, false, false, false, '');

// ---------------------------------------------------------

$sumaTotalIng = 0;
$num = 0;

foreach ($resIngresosGeneral as $key => $item) {
    $stotai = isset($item['subtotal']) ? $item['subtotal'] : 0;
$montoingre = number_format((float)$stotai, 2, '.', ',');      
$sumaTotalIng += $item['subtotal'];
$num = $num + 1;
$bloqDetIngresos = <<<EOF
		<table style="font-size:9px; padding:3px 9px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:10%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:70%;">{$item['rubro']}</td>
                <td style="border: 1px solid #666; text-align:center; width:20%;">$montoingre</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloqDetIngresos, false, false, false, false, '');
	
}

// ---------------------------------------------------------

$igf = str_replace(',', '', $sumaTotalIng); 
$igf = floatval($igf); 
$sumaTotalIngresos = number_format($igf, 2, '.', ',');

$literalingresos = numeroALetras($igf);

$bloqTotalIg = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; background-color:#ddd; text-align:right;width:80%;"><strong>Total Ingresos Bs </strong></td>
            <td style="border: 1px solid #666; background-color:#ddd; text-align:center;width:20%;"><strong>$sumaTotalIngresos</strong></td> 
		</tr>
		<tr>
		    <td style="border: 1px solid #666; background-color:#ddd; text-align:center;width:100%;"><strong>Son: $literalingresos</strong></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqTotalIg, false, false, false, false, '');


// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteGeneral.pdf', 'I');

}

}

$Reporte = new imprimirReporteGeneral();
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

function numeroALetras($numero) {
        $formatter = new NumberFormatter("es", NumberFormatter::SPELLOUT);
        
        // Separar la parte entera y la parte decimal
        $partes = explode('.', number_format($numero, 2, '.', ''));
        $parteEntera = $partes[0];
        $parteDecimal = isset($partes[1]) ? $partes[1] : '00';
    
        // Convertir la parte entera a letras
        $literal = ucfirst($formatter->format($parteEntera));
            $cero = "100";
        // Agregar la parte decimal en formato de centavos
        $moneda = "Bolivianos";
        $literal .= " $parteDecimal/$cero $moneda";
    
        return $literal;
}

?>