<?php

require_once "../../../modelos/reportesarchivo.modelo.php";

class imprimirReporteParada{

public $AltasBajasRpGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$AltasBajasRp = $this->AltasBajasRpGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuesta = ModeloReporteArchivo::mdlMostrarRepAltasBajasHerr($AltasBajasRp,$datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:500px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px;">
					<br>
					REPORTE DE $AltasBajasRp
					<br>
					HERRAMIENTAS DE TRABAJO
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
			    <br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:6%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:12%;">NOMBRE</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">PLACA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:13%;">PROC_LINEA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">TIPO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">MARCA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">COLOR</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:9%;">MODELO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:6%;">DIGI</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">DIA_RES</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:5%;">GP</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$num = 0;

foreach ($respuesta as $key => $item) {
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:6%;">{$num}</td>
                <td style="border: 1px solid #666; text-align:center; width:12%;">{$item['Nombre']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['Placa']}</td>
				<td style="border: 1px solid #666; text-align:center; width:13%;">{$item['procedencia_linea']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['tipo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['marca']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['color']}</td>
				<td style="border: 1px solid #666; text-align:center; width:9%;">{$item['modelo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:6%;">{$item['digito_restriccion']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['dia_restriccion']}</td>
				<td style="border: 1px solid #666; text-align:center; width:5%;">{$item['grupo']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteHerramientas.pdf', 'I');

}

}

$Reporte = new imprimirReporteParada();
$Reporte -> AltasBajasRpGET = $_GET["AltasBajasRp"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>