<?php

require_once "../../../modelos/reportesingegre.modelo.php";
require_once('tcpdf_include.php');
class MYPDF extends TCPDF {
    public function __construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa) {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        
        $this->setPrintFooter(false);
        // Establece márgenes (izquierdo, superior, derecho)
        $this->SetMargins(15, 25, 15);
        
        // Margen del encabezado (debe ser menor que el margen superior)
        $this->SetHeaderMargin(10);
        
        // Margen del pie de página
       // $this->SetFooterMargin(10);
        
        // Saltos de página automáticos
        $this->SetAutoPageBreak(TRUE, 25);
    }

    public function Header() {
        // Posición a 10 mm desde el borde superior
        $this->SetY(10);
        // Configura la fuente
        $this->SetFont('helvetica', '', 8);
        // Número de página
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().' de '.$this->getAliasNbPages(), 
            0, 0, 'C');
    }
}

class imprimirReporteIngresos{

public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;
$tabla = "tx_ingresos";

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$ancho = 370; // Ancho en milímetros (ejemplo: 210mm para A4)
$alto = 238;  // Alto en milímetros (ejemplo: 150mm personalizado)

$datos = array("fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuesta = ModeloIngresosEgresos::mdlMostrarReporteIngresos($tabla, $datos);

//$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf = new MYPDF('L', PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false, false);

$pdf->setPrintHeader(true);
$pdf->SetHeaderMargin(10); // Espacio reservado para el encabezado
$pdf->SetTopMargin(20);    // Margen superior para el contenido
$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<br>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:650px">
		        <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2025 V.2 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px;">
					REPORTE DE INGRESOS
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:9px; padding:3px 9px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:4%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:5%;">NroComp</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">CI</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:13%;">NOMBRE</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:9%;">FECHA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:22%;">RUBRO</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:30%;">DETALLE</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">MONTO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotalIng = 0;
$num = 0;

foreach ($respuesta as $key => $item) {
$sumaTotalIng += $item['subtotal'];
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:9px; padding:3px 9px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:4%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:5%;">{$item['nroing']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['ci']}</td>
				<td style="border: 1px solid #666; text-align:center; width:13%;">{$item['nombre']}</td>
                <td style="border: 1px solid #666; text-align:center; width:9%;">{$item['fecha']}</td>
                <td style="border: 1px solid #666; text-align:center; width:22%;">{$item['rubro']}</td>
                <td style="border: 1px solid #666; text-align:center; width:30%;">{$item['detalle']}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['subtotal']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotal = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:91%;"><strong>Total Ingresos Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:8%;"><strong>$sumaTotalIng</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotal, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteIngresos.pdf', 'I');

}

}

$Reporte = new imprimirReporteIngresos();
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>