<?php

require_once "../../../modelos/reportesarchivo.modelo.php";
require_once('tcpdf_include.php');
class MYPDF extends TCPDF {
    public function __construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa) {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        
        $this->setPrintFooter(false);
        // Establece márgenes (izquierdo, superior, derecho)
        $this->SetMargins(15, 25, 15);
        
        // Margen del encabezado (debe ser menor que el margen superior)
        $this->SetHeaderMargin(10);
        
        // Margen del pie de página
       // $this->SetFooterMargin(10);
        
        // Saltos de página automáticos
        $this->SetAutoPageBreak(TRUE, 25);
    }

    public function Header() {
        // Posición a 10 mm desde el borde superior
        $this->SetY(10);
        // Configura la fuente
        $this->SetFont('helvetica', '', 8);
        // Número de página
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().' de '.$this->getAliasNbPages(), 
            0, 0, 'C');
    }
}

class imprimirReporteArchivo{

public $heestadoRpGET;

public function traerImpresionReporte(){

$estado = $this->heestadoRpGET;

$datos = array("estado" => $estado);

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");
$fechaActual = date("Y/m/d");  

$ancho = 370; // Ancho en milímetros (ejemplo: 210mm para A4)
$alto = 238;  // Alto en milímetros (ejemplo: 150mm personalizado)

$respuesta = ModeloReporteArchivo::mdlMostrarListaVehiculos($datos);

$pdf = new MYPDF('L', PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false, false);

$pdf->setPrintHeader(true);
$pdf->SetHeaderMargin(10); // Espacio reservado para el encabezado
$pdf->SetTopMargin(20);    // Margen superior para el contenido
$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<br>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:650px" color:red>
                <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2025 V.2 - Hora impresion: $horaActual
                </div>
				<div style="font-size:10px; text-align:center; line-height:15px;">
					LISTADO GENERAL DE 
					<br>
					HERRAMIENTAS DE TRABAJO
					<br>
					AL: $fechaActual
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:8px; padding:5px 10px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:4%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:22%;">NOMBRE</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:7%;">PLACA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:22%;">PROC_LINEA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:7%;">TIPO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">MARCA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:7%;">COLOR</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:6%;">MODELO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:4%;">DIGI</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">DIA_RES</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:4%;">GP</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$num = 0;
foreach ($respuesta as $key => $item) {
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:8px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:4%;">{$num}</td>
                <td style="border: 1px solid #666; text-align:center; width:22%;">{$item['Nombre']}</td>
				<td style="border: 1px solid #666; text-align:center; width:7%;">{$item['Placa']}</td>
				<td style="border: 1px solid #666; text-align:center; width:22%;">{$item['procedencia_linea']}</td>
				<td style="border: 1px solid #666; text-align:center; width:7%;">{$item['tipo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:10%;">{$item['marca']}</td>
				<td style="border: 1px solid #666; text-align:center; width:7%;">{$item['color']}</td>
				<td style="border: 1px solid #666; text-align:center; width:6%;">{$item['modelo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:4%;">{$item['digito_restriccion']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['dia_restriccion']}</td>
				<td style="border: 1px solid #666; text-align:center; width:4%;">{$item['grupo']}</td>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}


// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteListadoHerrTrab.pdf', 'I');

}

}

$Reporte = new imprimirReporteArchivo();
$Reporte -> heestadoRpGET = $_GET["heestadoRp"];
$Reporte -> traerImpresionReporte();

?>