<?php

require_once "../../../modelos/reportesarchivo.modelo.php";
require_once('tcpdf_include.php');
class MYPDF extends TCPDF {
    public function __construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa) {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        
        $this->setPrintFooter(false);
        // Establece márgenes (izquierdo, superior, derecho)
        $this->SetMargins(15, 25, 15);
        
        // Margen del encabezado (debe ser menor que el margen superior)
        $this->SetHeaderMargin(10);
        
        // Margen del pie de página
       // $this->SetFooterMargin(10);
        
        // Saltos de página automáticos
        $this->SetAutoPageBreak(TRUE, 25);
    }

    public function Header() {
        // Posición a 10 mm desde el borde superior
        $this->SetY(10);
        // Configura la fuente
        $this->SetFont('helvetica', '', 8);
        // Número de página
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().' de '.$this->getAliasNbPages(), 
            0, 0, 'C');
    }
}

class imprimirReporteArchivo{

public $soestadoRpGET;

public function traerImpresionReporte(){

$estado = $this->soestadoRpGET;

$datos = array("estado" => $estado);

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");
$fechaActual = date("Y/m/d");  

$ancho = 370; // Ancho en milímetros (ejemplo: 210mm para A4)
$alto = 238;  // Alto en milímetros (ejemplo: 150mm personalizado)

$respuesta = ModeloReporteArchivo::mdlMostrarReporteSocios($datos);

$pdf = new MYPDF('L', PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false, false);

$pdf->setPrintHeader(true);
$pdf->SetHeaderMargin(10); // Espacio reservado para el encabezado
$pdf->SetTopMargin(20);    // Margen superior para el contenido
$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:650px" color:red>
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2025 V.2 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px;">
					LISTA DE PROPIETARIOS (SOCIOS)
					<br>
					AL : $fechaActual
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:8px; padding:5px 10px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:4%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:7%;">C.I.</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:14%;">NOMBRES</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:16%;">APELLIDOS</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">FECHA ING</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">CELULAR</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:21%;">DIR_ZONA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:23%;">DIR_CALLE</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$num = 0;
foreach ($respuesta as $key => $item) {
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:8px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:4%;">{$num}</td>
                <td style="border: 1px solid #666; text-align:center; width:7%;">{$item['ci']}</td>
				<td style="border: 1px solid #666; text-align:center; width:14%;">{$item['nombres']}</td>
				<td style="border: 1px solid #666; text-align:center; width:16%;">{$item['apellidos']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['fec_ingreso']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['celular']}</td>
				<td style="border: 1px solid #666; text-align:center; width:21%;">{$item['direc_zona']}</td>
				<td style="border: 1px solid #666; text-align:center; width:23%;">{$item['direc_calle']}</td>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}


// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteListaPropietarios.pdf', 'I');

}

}

$Reporte = new imprimirReporteArchivo();
$Reporte -> soestadoRpGET = $_GET["soestadoRp"];
$Reporte -> traerImpresionReporte();

?>