<?php

require_once "../../../modelos/reportesmensual.modelo.php";
require_once('tcpdf_include.php');
class MYPDF extends TCPDF {
    public function __construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa) {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        
        $this->setPrintFooter(false);
        // Establece márgenes (izquierdo, superior, derecho)
        $this->SetMargins(15, 25, 15);
        
        // Margen del encabezado (debe ser menor que el margen superior)
        $this->SetHeaderMargin(10);
        
        // Margen del pie de página
       // $this->SetFooterMargin(10);
        
        // Saltos de página automáticos
        $this->SetAutoPageBreak(TRUE, 25);
    }

    public function Header() {
        // Posición a 10 mm desde el borde superior
        $this->SetY(10);
        // Configura la fuente
        $this->SetFont('helvetica', '', 8);
        // Número de página
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().' de '.$this->getAliasNbPages(), 
            0, 0, 'C');
    }
}

class imprimirReporteMensualGeneral{

public $estadomenGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$estadomen = $this->estadomenGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;

$datos = array("repestadomen" => $estadomen,
               "FechaIni" => $FechaIni,
               "FechaFin" => $FechaFin);
$respuestameses = ModeloReporteMensual::mdlMostrarMensualGeneralEstado($datos);
$respuestamesesbajas = ModeloReporteMensual::mdlMostrarBajasMensual($datos);
$respuestarubrosvarios = ModeloReporteMensual::mdlMostrarRubrosMensual($datos);
$respuestavarios = ModeloReporteMensual::mdlMostrarMensualGeneralEstadoVar($datos);
$respuestavariosbajas = ModeloReporteMensual::mdlMostrarBajasMensualVarios($datos);

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

//require_once('tcpdf_include.php');

$ancho = 370; // Ancho en milímetros (ejemplo: 210mm para A4)
$alto = 218;  // Alto en milímetros (ejemplo: 150mm personalizado)

//$pdf = new TCPDF('L', PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false);
$pdf = new MYPDF('L', PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false, false);
$pdf->setPrintHeader(true);

$pdf->SetHeaderMargin(10); // Espacio reservado para el encabezado
$pdf->SetTopMargin(20);    // Margen superior para el contenido
$pdf->startPageGroup();

$pdf->AddPage();
if ($estadomen == 'PRO'){
	$tipo = "PROPIETARIO";
}
if ($estadomen == 'ASA'){
	$tipo = "ASALARIADO";
}
if ($estadomen == 'INS'){
	$tipo = "AUTORIDAD";
}
if ($estadomen == '%'){
	$tipo = "TODOS";
}
$bloque1 = <<<EOF
	<table>
		<tr>	
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:550px">
                <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2025 V.2 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px; color:blue">
					REPORTE APORTES MENSUALES
					<br>
					DE: $tipo
                    <br>
                    Del: $FechaIni Al $FechaFin
                    <br>
				</div>
			</td>
		</tr>
	</table>
	<br>
	<br>
EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------
$data = []; // Inicializa el array donde vaciarás los datos

foreach ($respuestameses as $item) {
    $data[] = [
        'ci' => $item['nombre_completo'],  // Vacías el campo 'nombres' en 'ci'
        'mes' => $item['rubro'],   // Vacías el campo 'rubro' en 'mes'
        'monto' => $item['monto']  // Vacías el campo 'monto'
    ];
}

foreach ($respuestamesesbajas as $itemb) {
    $data[] = [
        'ci' => $itemb['nombre_completo'],  // Vacías el campo 'nombres' en 'ci'
        'mes' => $itemb['rubro'],   // Vacías el campo 'rubro' en 'mes'
        'monto' => $itemb['monto']  // Vacías el campo 'monto'
    ];
}

// Encabezado de la tabla
$pdf->SetFont('helvetica', 'B', 8);
$pdf->SetFillColor(200, 220, 255); // Color del encabezado
$pdf->Ln();

// La primera celda vacía (esquina superior izquierda) antes de los meses
$pdf->Cell(80, 7, 'NOMBRE APELLIDOS', 1, 0, 'C', true);

// Mostrar los meses como encabezados
$meses = ['ENERO', 'FEBRERO', 'MARZO', 'ABRIL', 'MAYO', 'JUNIO', 'JULIO', 'AGOSTO', 'SEPTIEMBRE', 'OCTUBRE', 'NOVIEMBRE', 'DICIEMBRE'];
$totalesPorMes = array_fill_keys($meses, 0); // Inicializa totales de cada mes a 0
$totalesPorSocio = []; // Para los totales de cada socio

foreach ($meses as $mes) {
    $pdf->Cell(20, 7, $mes, 1, 0, 'C', true);
}
$pdf->Cell(30, 7, 'TOTAL SOCIO', 1, 0, 'C', true); // Columna para total por socio
$pdf->Ln(); // Nueva línea

// Mostrar los datos por CI
$pdf->SetFont('helvetica', '', 8);
foreach (array_unique(array_column($data, 'ci')) as $ci) {
    $pdf->Cell(80, 7, $ci, 1, 0, 'C');  // Imprimir el CI al inicio de la fila

    $totalSocio = 0; // Inicializa total por socio

    // Rellenar la fila con los montos por mes
    foreach ($meses as $mes) {
        $monto = 0;
        foreach ($data as $row) {
            if ($row['ci'] == $ci && $row['mes'] == $mes) {
                $monto = $row['monto'];
                break;
            }
        }
        $pdf->Cell(20, 7, $monto, 1, 0, 'C'); // Celda para el monto
        $totalSocio += $monto; // Sumar al total por socio
        $totalesPorMes[$mes] += $monto; // Sumar al total por mes
    }

    $pdf->Cell(30, 7, $totalSocio, 1, 0, 'C'); // Mostrar total por socio
    $pdf->Ln(); // Nueva línea después de cada CI

    // Guardar total por socio
    $totalesPorSocio[$ci] = $totalSocio;
}


// Mostrar los totales por mes al final
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Cell(80, 7, 'TOTAL MES', 1, 0, 'C', true); // Celda para el texto "TOTAL MES"
foreach ($meses as $mes) {
    $pdf->Cell(20, 7, $totalesPorMes[$mes], 1, 0, 'C', true); // Mostrar el total por mes
}
$pdf->Cell(30, 7, array_sum($totalesPorSocio), 1, 0, 'C', true); // Total general de todos los socios
$pdf->Ln();

// ------------------------------------------------------------------------------------------------------


$bloque21 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="background-color:white; width:550px">
				<div style="font-size:10px; text-align:center; line-height:35px; color:blue">
					OTROS APORTES MENSUALES / AYUDAS Y TARJETAS
				</div>
			</td>
		</tr>
	</table>
	<br>
	<br>
EOF;

$pdf->writeHTML($bloque21, false, false, false, false, '');

$data = []; // Inicializa el array donde vaciarás los datos

foreach ($respuestavarios as $item) {
    $data[] = [
        'ci' => $item['nombre_completo'],  // Vacías el campo 'nombres' en 'ci'
        'mes' => $item['rubro'],   // Vacías el campo 'rubro' en 'mes'
        'monto' => $item['monto']  // Vacías el campo 'monto'
    ];
}

foreach ($respuestavariosbajas as $itembv) {
    $data[] = [
        'ci' => $itembv['nombre_completo'],  // Vacías el campo 'nombres' en 'ci'
        'mes' => $itembv['rubro'],   // Vacías el campo 'rubro' en 'mes'
        'monto' => $itembv['monto']  // Vacías el campo 'monto'
    ];
}


$variosrub = array_map('strtoupper', array_column($respuestarubrosvarios, 'rubro')); // Cambiar según la estructura de tus datos
$totalesPorMes = array_fill_keys($variosrub, 0); // Inicializa totales de cada mes a 0

$bloque4 = <<<EOF
<br>
<br>
<table style="font-size:8px; padding:5px 10px; border-collapse: collapse;">
    <tr>
        <td style="border: 1px solid #666; background-color:#c8dcff; text-align:center; width:23%;">NOMBRE APELLIDOS</td>
EOF;

// Mostrar los meses como encabezados
foreach ($respuestarubrosvarios as $mes) {
    //$bloque4 .= "<td style=\"border: 1px solid #666; text-align:center; width:7%;\">{$mes['rubro']}</td>";
	$bloque4 .= "<td style=\"border: 1px solid #666; background-color:#c8dcff;text-align:center; width:6%;\">{$mes['rubro']}</td>";
}
$bloque4 .= "<td style=\"border: 1px solid #666; background-color:#c8dcff;text-align:center; width:6%;\">TOTAL SOCIO</td>";
$bloque4 .= "</tr>";
$totalvarios = 0;
// Mostrar los datos por CI
foreach (array_unique(array_column($data, 'ci')) as $index => $ci) {
    $bloque4 .= "<tr>";
    $bloque4 .= "<td style=\"border: 1px solid #666; text-align:center; width:23%;\">$ci</td>";

    $totalSocio = 0; // Inicializa total por socio
    

    // Rellenar la fila con los montos por mes
    foreach ($respuestarubrosvarios as $mes) {
        $monto = 0;
        foreach ($data as $row) {
            if ($row['ci'] == $ci && $row['mes'] == $mes['rubro']) {
                $monto = $row['monto'];
                break;
            }
        }
        $bloque4 .= "<td style=\"border: 1px solid #666; text-align:center; width:6%;\">$monto</td>"; // Celda para el monto
        $totalSocio += $monto; // Sumar al total por socio
        $totalesPorMes[$mes['rubro']] += $monto; // Sumar al total por mes
        $totalvarios += $monto;
    }

    $bloque4 .= "<td style=\"border: 1px solid #666; text-align:center; width:6%;\">$totalSocio</td>"; // Mostrar total por socio
    $bloque4 .= "</tr>"; // Cierra la fila
	$totalesPorSocio[$ci] = $totalSocio;
}

// Mostrar los totales por mes al final
$bloque4 .= "<tr style=\"font-weight:bold;\"><td style=\"border: 1px solid #666; text-align:center;\">TOTAL MES</td>";

foreach ($respuestarubrosvarios as $mesva) {
    $bloque4 .= "<td style=\"border: 1px solid #666; text-align:center;\">{$totalesPorMes[$mesva['rubro']]}</td>"; // Mostrar el total por mes
}
$bloque4 .= "<td style=\"border: 1px solid #666; text-align:center;\">". $totalvarios ."</td>"; // Total general de todos los socios
$bloque4 .= "</tr></table>";

// Escribir el HTML en el PDF
$pdf->writeHTML($bloque4, true, false, true, false, '');

// Salida del archivo
$pdf->Output('ReporteGeneralMensual.pdf', 'I');

}

}

$Reporte = new imprimirReporteMensualGeneral();
$Reporte -> estadomenGET = $_GET["estadomen"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>