<?php

require_once "../../../modelos/reportesmensual.modelo.php";

class imprimirReporteMensualItem{

public $rubromenGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$rubromen = $this->rubromenGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;
$tablaig = "tx_deudas";

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("reprubromen" => $rubromen,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuestamensual = ModeloReporteMensual::mdlMostrarReporteMensualRubro($tablaig,$datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:350px">
                <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px; color:blue">
					REPORTE MENSUAL POR RUBRO
					<br>
					Del: $FechaIni Al: $FechaFin
					<br>
					RUBRO: $rubromen
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:blue"><br></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------
$bloqueEncabezado = <<<EOF
        <table style="font-size:8px; padding:5px 10px;">
            <tr>
				<br>
			    <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:7%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:35%;">NOMBRES</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:17%;">FECHA PAGO</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:12%;">NRO RECIBO</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:12%;">MONTO</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotal = 0;
$num = 0;

foreach ($respuestamensual as $key => $item) {
$sumaTotal += $item['monto'];
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:8px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:7%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:35%;">{$item['nombre_completo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:17%;">{$item['fechapago']}</td>
                <td style="border: 1px solid #666; text-align:center; width:12%;">{$item['nrorecibo']}</td>
				<td style="border: 1px solid #666; text-align:center; width:12%;">{$item['monto']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotalIng = <<<EOF
	<table style="font-size:8px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:71%;"><strong>Total Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:12%;"><strong>$sumaTotal</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotalIng, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteRubroDeudas.pdf', 'I');

}

}

$Reporte = new imprimirReporteMensualItem();
$Reporte -> rubromenGET = $_GET["rubromen"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>