<?php

require_once "../../../modelos/reportesapp.modelo.php";

class imprimirReporteParada{

public $ageparGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$agepar = $this->ageparGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("agepar" => $agepar,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuesta = ModeloReporteApp::mdlMostrarReporteAgente($datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<br>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:300px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px;">
					REPORTE DE VENTA POR DIA DE RESTRICCION
					<br>
					Del: $FechaIni Al: $FechaFin
					<br>
					AGENTE: $agepar
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
			<br>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">Nro Ticket</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:12%;">PLACA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">Bs.</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:14%;">FECHA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:11%;">HORA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:23%;">CONDUCTOR</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">PARADA</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotalCosto = 0;
$num = 0;
foreach ($respuesta as $key => $item) {
$sumaTotalCosto += $item['Costo'];
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
			    <td style="border: 1px solid #666; text-align:center; width:8%;">{$num}</td>
                <td style="border: 1px solid #666; text-align:center; width:10%;">{$item['idTicket']}</td>
                <td style="border: 1px solid #666; text-align:center; width:12%;">{$item['Placa']}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['Costo']}</td>
                <td style="border: 1px solid #666; text-align:center; width:14%;">{$item['Fecha']}</td>
                <td style="border: 1px solid #666; text-align:center; width:11%;">{$item['Hora']}</td>
                <td style="border: 1px solid #666; text-align:center; width:23%;">{$item['Conductor']}</td>
                <td style="border: 1px solid #666; text-align:center; width:15%;">{$item['Parada']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotal = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:30%;"><strong>Total Monto Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:8%;"><strong>$sumaTotalCosto</strong></td>
            <td style="border: 1px solid #666;width:63%;"></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotal, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteVentaAgente.pdf', 'I');

}

}

$Reporte = new imprimirReporteParada();
$Reporte -> ageparGET = $_GET["ageparRp"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>