<?php

require_once "../../../modelos/reportesapp.modelo.php";

class imprimirReporteParada{

public $diaGET;
public $feciniGET;
public $fecfinGET;

public function traerImpresionReporte(){

$dia = $this->diaGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$datos = array("repdia" => $dia,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuesta = ModeloReporteApp::mdlMostrarReporteDia($datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<br>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:500px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px;">
					REPORTE DE VENTA POR DIA DE RESTRICCION
					<br>
					Del: $FechaIni Al: $FechaFin
					<br>
					DIA DE RESTRICCION: $dia
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center; color:red"></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:5%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">Nro Ticket</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">PLACA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">Bs.</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">FECHA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">HORA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:23%;">CONDUCTOR</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">PARADA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">DIA</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotalCosto = 0;
$num = 0;
foreach ($respuesta as $key => $item) {
$sumaTotalCosto += $item['Costo'];
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:5%;">{$num}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['idTicket']}</td>
                <td style="border: 1px solid #666; text-align:center; width:10%;">{$item['Placa']}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['Costo']}</td>
                <td style="border: 1px solid #666; text-align:center; width:10%;">{$item['Fecha']}</td>
                <td style="border: 1px solid #666; text-align:center; width:10%;">{$item['Hora']}</td>
                <td style="border: 1px solid #666; text-align:center; width:23%;">{$item['Conductor']}</td>
                <td style="border: 1px solid #666; text-align:center; width:15%;">{$item['Parada']}</td>
				<td style="border: 1px solid #666; text-align:center; width:8%;">{$item['dia_restriccion']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotal = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:23%;"><strong>Total Monto Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:8%;"><strong>$sumaTotalCosto</strong></td>
            <td style="border: 1px solid #666;width:66%;"></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotal, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteDiaRestriccion.pdf', 'I');

}

}

$Reporte = new imprimirReporteParada();
$Reporte -> diaGET = $_GET["diaRp"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>