<?php

require_once "../../../modelos/reportesapp.modelo.php";
require_once('tcpdf_include.php');
class MYPDF extends TCPDF {
    public function __construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa) {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        
        $this->setPrintFooter(false);
        // Establece márgenes (izquierdo, superior, derecho)
        $this->SetMargins(15, 25, 15);
        
        // Margen del encabezado (debe ser menor que el margen superior)
        $this->SetHeaderMargin(10);
        
        // Margen del pie de página
       // $this->SetFooterMargin(10);
        
        // Saltos de página automáticos
        $this->SetAutoPageBreak(TRUE, 25);
    }

    public function Header() {
        // Posición a 10 mm desde el borde superior
        $this->SetY(10);
        // Configura la fuente
        $this->SetFont('helvetica', '', 8);
        // Número de página
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().' de '.$this->getAliasNbPages(), 
            0, 0, 'C');
    }
}


class imprimirReporteParada{

public $paradaGET;
public $feciniGET;
public $fecfinGET;
public $ParadaTitulo;

public function traerImpresionReporte(){

$Parada = $this->paradaGET;
$FechaIni = $this->feciniGET;
$FechaFin = $this->fecfinGET;

date_default_timezone_set("America/La_Paz");
$horaActual = date("H:i:s");

$ancho = 370; // Ancho en milímetros (ejemplo: 210mm para A4)
$alto = 238;  // Alto en milímetros (ejemplo: 150mm personalizado)

$tabla = "tx_ventatickets";

if($Parada == '%'){
	$ParadaTitulo = "TODAS";
}else{
  $ParadaTitulo = $Parada;	
}


$datos = array("rep1Parada" => "PARADA ".$Parada,
"fechaInicio" => $FechaIni,
"fechaFin" => $FechaFin);
$respuesta = ModeloReporteApp::mdlMostrarReporteParada($tabla, $datos);

$pdf = new MYPDF('L', PDF_UNIT, array($ancho, $alto), true, 'UTF-8', false, false);

$pdf->setPrintHeader(true);
$pdf->SetHeaderMargin(10); // Espacio reservado para el encabezado
$pdf->SetTopMargin(20);    // Margen superior para el contenido
$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF

	<table>
		<tr>
			<br>
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:650px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2025 V.2 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px;">
					REPORTE DE VENTA POR PARADA
					<br>
					Del: $FechaIni Al: $FechaFin
					<br>PARADA: $ParadaTitulo
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------

$bloqueEncabezado = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
				<br>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:5%;">#</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:7%;">Nro Ticket</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">PLACA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:4%;">Bs.</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:9%;">FECHA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:8%;">HORA</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:28%;">CONDUCTOR</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:15%;">PARADA</th>
				<th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:16%;">AGENTE</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

$sumaTotalCosto = 0;
$num = 0;

foreach ($respuesta as $key => $item) {
$sumaTotalCosto += $item['Costo'];
$num = $num + 1;
$bloque4 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
				<td style="border: 1px solid #666; text-align:center; width:5%;">$num</td>
                <td style="border: 1px solid #666; text-align:center; width:7%;">{$item['idTicket']}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['Placa']}</td>
                <td style="border: 1px solid #666; text-align:center; width:4%;">{$item['Costo']}</td>
                <td style="border: 1px solid #666; text-align:center; width:9%;">{$item['Fecha']}</td>
                <td style="border: 1px solid #666; text-align:center; width:8%;">{$item['Hora']}</td>
                <td style="border: 1px solid #666; text-align:center; width:28%;">{$item['Conductor']}</td>
                <td style="border: 1px solid #666; text-align:center; width:15%;">{$item['Parada']}</td>
                <td style="border: 1px solid #666; text-align:center; width:15%;">{$item['NombreApp']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ------------------------------------------------------------------------------------------------------

$bloqueTotal = <<<EOF
	<table style="font-size:10px; padding:5px 10px;">
		<tr>
            <td style="border: 1px solid #666; text-align:right;width:20%;"><strong>Total Monto Bs </strong></td>
            <td style="border: 1px solid #666; text-align:center;width:4%;"><strong>$sumaTotalCosto</strong></td> 
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloqueTotal, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteParada.pdf', 'I');

}

}

$Reporte = new imprimirReporteParada();
$Reporte -> paradaGET = $_GET["paradaRp"];
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>