<?php

require_once "../../../modelos/reportesapp.modelo.php";

class imprimirReporteParada{

public function traerImpresionReporte(){

	$FechaIni = $this->feciniGET;
	$FechaFin = $this->fecfinGET;
	
	date_default_timezone_set("America/La_Paz");
	$horaActual = date("H:i:s");

	$datos = array("fechaInicio" => $FechaIni,
	"fechaFin" => $FechaFin);

$respuesta = ModeloReporteApp::mdlMostrarReporteTotalGrupo($datos);

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

$bloque1 = <<<EOF
	<table>
		<tr>
			<br>		
			<td style="width:150px"><img src="images/logo.png"></td>
			<td style="background-color:white; width:300px">
			    <div style="font-size:7px; text-align:center;">
                    Sistema Correnet 2024 V.1 - Hora impresion: $horaActual
                </div>
				<div style="font-size:13px; text-align:center; line-height:15px; color:green">
					REPORTE DE VENTA TOTALIZADO POR GRUPO
					<br>
					Del: $FechaIni Al: $FechaFin
				</div>
			</td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ----------------------------------------------------------------------------
$bloqueEncabezado = <<<EOF
        <table style="font-size:10px; padding:5px 10px;">
            <tr>
				<br>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:12%;">Grupo</th>
                <th style="border: 1px solid #666; background-color:#ddd; text-align:center; width:10%;">Total Bs.</th>
            </tr>
		</table>
EOF;
$pdf->writeHTML($bloqueEncabezado, false, false, false, false, '');

// ----------------------------------------------------------------------------

foreach ($respuesta as $key => $item) {
$bloque4 = <<<EOF
		<table style="font-size:10px; padding:5px 10px;">
			<tr>
                <td style="border: 1px solid #666; text-align:center; width:12%;">{$item['grupo']}</td>
                <td style="border: 1px solid #666; text-align:center; width:10%;">{$item['TotalCosto']}</td>
            </tr>
		</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');
	
}

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

$pdf->Output('ReporteSubgrupoTotal.pdf', 'I');

}

}

$Reporte = new imprimirReporteParada();
$Reporte -> feciniGET = $_GET["fec_ini"];
$Reporte -> fecfinGET = $_GET["fec_fin"];
$Reporte -> traerImpresionReporte();

?>