<?php

require_once "conexion.php";

class ModeloAgenteDisp{

	/*=============================================
	MOSTRAR DISPOSITIVO
	=============================================*/

	static public function mdlMostrarDispositivos($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}
		

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	REGISTRO DE AGENTE DISPOSITIVO
	=============================================*/

	static public function mdlIngresarAgenteDisp($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(NombreApp, Parada, Numero, ModCelular, IMEI, Password, usuariosys) 
												VALUES (:nombre, :parada, :numero, :modelo, :key, :password, :usuario)");

		$stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
		$stmt->bindParam(":parada", $datos["parada"], PDO::PARAM_STR);
		$stmt->bindParam(":numero", $datos["numero"], PDO::PARAM_STR);
		$stmt->bindParam(":modelo", $datos["modelo"], PDO::PARAM_STR);
		$stmt->bindParam(":key", $datos["key"], PDO::PARAM_STR);
		$stmt->bindParam(":password", $datos["password"], PDO::PARAM_STR);
		$stmt->bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";	

		}else{

			return "error";
		
		}

		$stmt->close();
		
		$stmt = null;

	}

	/*=============================================
	EDITAR AGENTE
	=============================================*/

	static public function mdlEditarAgente($tabla, $datos){
		try {
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET NombreApp=:nombre, Password=:password, ModCelular=:modelo, usuariosys=:usuario, Numero=:numero,IMEI=:key ,Parada=:parada WHERE id=:id;");

		$stmt->bindParam(":id", $datos["id"], PDO::PARAM_STR);
		$stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
		$stmt->bindParam(":parada", $datos["parada"], PDO::PARAM_STR);
		$stmt->bindParam(":numero", $datos["numero"], PDO::PARAM_STR);
		$stmt->bindParam(":modelo", $datos["modelo"], PDO::PARAM_STR);
		$stmt->bindParam(":key", $datos["key"], PDO::PARAM_STR);
		$stmt->bindParam(":password", $datos["password"], PDO::PARAM_STR);
		$stmt->bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		//console.log("CI del propietario:", ciPropietario);
		} catch (PDOException $e) {
			// Verificar si es un error de duplicado
			if ($e->getCode() == 23000) {
				return "duplicate"; // Valor de retorno para indicar un duplicado
			} else {
				return "error";
			}
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	EDITAR ROTE
	=============================================*/

	static public function mdlEditarRote($tabla, $datos){
		try {
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET Password=:password, usuariosys=:usuario, fecha_rote=current_timestamp() WHERE Parada=:parada;");

		$stmt->bindParam(":parada", $datos["parada"], PDO::PARAM_STR);
		$stmt->bindParam(":password", $datos["password"], PDO::PARAM_STR);
		$stmt->bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		//console.log("CI del propietario:", ciPropietario);
		} catch (PDOException $e) {
			// Verificar si es un error de duplicado
			if ($e->getCode() == 23000) {
				return "duplicate"; // Valor de retorno para indicar un duplicado
			} else {
				return "error";
			}
		}
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	ACTUALIZAR ESTADO AGENTE DISPOSITIVO
	=============================================*/

	static public function mdlActualizarAgente($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	BORRAR AGENTE DISPOSITIVO
	=============================================*/

	static public function mdlBorrarAgentedisp($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;


	}

}