<?php

require_once "conexion.php";

class ModeloAsalariados{

	/*=============================================
	MOSTRAR ASALARIADO
	=============================================*/

	static public function MdlMostrarAsalariados($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado <> '2'");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}
		

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	REGISTRO DE ASALARIADO
	=============================================*/

	static public function mdlIngresarAsalariados($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(ci, nombres, apellidos, fec_ingreso, direc_zona, direc_calle, celular, nombre_garante, antecedentes, permiso, fecha_alta, usuario) 
												VALUES (:ci, :nombres, :apellidos, :fec_ingreso, :direc_zona, :direc_calle, :celular, :nombre_garante, :antecedentes, :permiso, current_timestamp(),:usuario)");

		$stmt->bindParam(":ci", $datos["ci"], PDO::PARAM_STR);
		$stmt->bindParam(":nombres", $datos["nombres"], PDO::PARAM_STR);
		$stmt->bindParam(":apellidos", $datos["apellidos"], PDO::PARAM_STR);
		$stmt->bindParam(":fec_ingreso", $datos["fec_ingreso"], PDO::PARAM_STR);
		$stmt->bindParam(":celular", $datos["celular"], PDO::PARAM_STR);
		$stmt->bindParam(":direc_zona", $datos["direc_zona"], PDO::PARAM_STR);
		$stmt->bindParam(":direc_calle", $datos["direc_calle"], PDO::PARAM_STR);
		$stmt->bindParam(":nombre_garante", $datos["nombre_garante"], PDO::PARAM_STR);
		$stmt->bindParam(":antecedentes", $datos["antecedentes"], PDO::PARAM_STR);
		$stmt->bindParam(":permiso", $datos["permiso"], PDO::PARAM_STR);
		$stmt->bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";	

		}else{

			return "error";
		
		}

		$stmt->close();
		
		$stmt = null;

	}

	/*=============================================
	EDITAR ASALARIADO
	=============================================*/

	static public function mdlEditarAsalariado($tabla, $datos){
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET nombres=:nombres, apellidos=:apellidos, fec_ingreso=:fec_ingreso, celular=:celular, direc_zona=:direc_zona, direc_calle=:direc_calle, nombre_garante=:nombre_garante, fecha_mod=current_timestamp(), antecedentes=:antecedentes, permiso=:permiso, usuario=:usuario 
											   WHERE ci=:ci;");

		$stmt -> bindParam(":ci", $datos["ci"], PDO::PARAM_STR);
		$stmt -> bindParam(":nombres", $datos["nombres"], PDO::PARAM_STR);
		$stmt -> bindParam(":apellidos", $datos["apellidos"], PDO::PARAM_STR);
		$stmt -> bindParam(":fec_ingreso", $datos["fec_ingreso"], PDO::PARAM_STR);
		$stmt -> bindParam(":celular", $datos["celular"], PDO::PARAM_STR);
		$stmt -> bindParam(":direc_zona", $datos["direc_zona"], PDO::PARAM_STR);
		$stmt -> bindParam(":direc_calle", $datos["direc_calle"], PDO::PARAM_STR);
		$stmt -> bindParam(":nombre_garante", $datos["nombre_garante"], PDO::PARAM_STR);
		$stmt -> bindParam(":antecedentes", $datos["antecedentes"], PDO::PARAM_STR);
		$stmt -> bindParam(":permiso", $datos["permiso"], PDO::PARAM_STR);
		$stmt -> bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	ACTUALIZAR ASALARIADO
	=============================================*/

	static public function mdlActualizarAsalariado($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	BAJA ASALARIADO
	=============================================*/

	static public function mdlBajaAsalariado($tabla, $datos){
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET fecha_baja=current_timestamp(),usuario=:usuario, estado='2' WHERE ci=:ci;");
	
		$stmt -> bindParam(":ci", $datos["ci"], PDO::PARAM_STR);
		$stmt -> bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	RECUPERA GARANTES
	=============================================*/

	static public function mdlMostrarGarantes(){
		$stmt = Conexion::conectar()->prepare("SELECT CONCAT(nombres, ' ', apellidos) AS nombreGarante FROM tx_propietarios WHERE estado = '1' GROUP by nombreGarante");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	VALIDA CI DE ASALARIADO
	=============================================*/

	static public function mdlValidaCiAsalariado($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT ci FROM $tabla WHERE ci = :ciasa;");
		$stmt->bindParam(":ciasa", $datos["ciasa"], PDO::PARAM_STR);
		$stmt -> execute();

		$resultadopl = $stmt->fetch(PDO::FETCH_ASSOC); 
		return $resultadopl ? $resultadopl["ci"] : false;
		
		$stmt->close();
		$stmt = null;
	}

}