<?php

require_once "conexion.php";

class ModeloPropietarios{

	/*=============================================
	MOSTRAR PROPIETARIOS
	=============================================*/

	static public function MdlMostrarPropietarios($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado <> '2'");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}
		

		$stmt -> close();

		$stmt = null;

	}



	static public function MdlMostrarApuesta($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = 'Pendiente'");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}
		

		$stmt -> close();

		$stmt = null;

	} 

	/*=============================================
	REGISTRO DE PROPIETARIO
	=============================================*/

	static public function mdlIngresarPropietarios($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(Disciplina, Equipo1, Res1, Equipo2, Res2, Fecha, hora, Montoapuesta,estado) 
												VALUES (:Disciplina, :Equipo1, :Res1, :Equipo2, :Res2, :Fecha, :hora, :Montoapuesta,:estado)");

		$stmt->bindParam(":Disciplina", $datos["Disciplina"], PDO::PARAM_STR);
		$stmt->bindParam(":Equipo1", $datos["Equipo1"], PDO::PARAM_STR);
		$stmt->bindParam(":Res1", $datos["Res1"], PDO::PARAM_STR);
		$stmt->bindParam(":Fecha", $datos["Fecha"], PDO::PARAM_STR);
		$stmt->bindParam(":Equipo2", $datos["Equipo2"], PDO::PARAM_STR);
		$stmt->bindParam(":Res2", $datos["Res2"], PDO::PARAM_STR);
		$stmt->bindParam(":hora", $datos["hora"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $datos["estado"], PDO::PARAM_STR);
		$stmt->bindParam(":Montoapuesta", $datos["Montoapuesta"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";	

		}else{

			return "error";
		
		}

		$stmt->close();
		
		$stmt = null;

	}


		/*=============================================
	REGISTRO DE PROPIETARIO
	=============================================*/

	static public function mdlIngresarApuesta($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(idev, Equipo1, Res1, Equipo2, Res2, Fecha, monto,usuario) 
												VALUES (:idev, :Equipo1, :Res1, :Equipo2, :Res2, current_timestamp(),:monto ,:usuario)");

		$stmt->bindParam(":idev", $datos["idev"], PDO::PARAM_STR);
		$stmt->bindParam(":Equipo1", $datos["Equipo1"], PDO::PARAM_STR);
		$stmt->bindParam(":Res1", $datos["Res1"], PDO::PARAM_STR);
		$stmt->bindParam(":Equipo2", $datos["Equipo2"], PDO::PARAM_STR);
		$stmt->bindParam(":Res2", $datos["Res2"], PDO::PARAM_STR);
		$stmt->bindParam(":monto", $datos["monto"], PDO::PARAM_STR);
		$stmt->bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";	

		}else{

			return "error";
		
		}

		$stmt->close();
		
		$stmt = null;

	}

	/*=============================================
	EDITAR PROPIETARIO
	=============================================*/

	static public function mdlEditarPropietario($tabla, $datos){
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET Disciplina=:Disciplina, Equipo1=:Equipo1, Res1=:Res1, Equipo2=:Equipo2, Res2=:Res2, Fecha=:Fecha, hora=:hora, estado=:estado, Montoapuesta=:Montoapuesta, Ganador=:Ganador
											   WHERE id=:id;");

		$stmt -> bindParam(":id", $datos["id"], PDO::PARAM_STR);
		$stmt -> bindParam(":Disciplina", $datos["Disciplina"], PDO::PARAM_STR);
		$stmt -> bindParam(":Equipo1", $datos["Equipo1"], PDO::PARAM_STR);
		$stmt -> bindParam(":Res1", $datos["Res1"], PDO::PARAM_STR);
		$stmt -> bindParam(":Fecha", $datos["Fecha"], PDO::PARAM_STR);
		$stmt -> bindParam(":Equipo2", $datos["Equipo2"], PDO::PARAM_STR);
		$stmt -> bindParam(":Res2", $datos["Res2"], PDO::PARAM_STR);
		$stmt -> bindParam(":hora", $datos["hora"], PDO::PARAM_STR);
		$stmt -> bindParam(":estado", $datos["estado"], PDO::PARAM_STR);
		$stmt -> bindParam(":Ganador", $datos["Ganador"], PDO::PARAM_STR);
		$stmt -> bindParam(":Montoapuesta", $datos["Montoapuesta"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	ACTIVAR O DESACTIVAR PROPIETARIO
	=============================================*/

	static public function mdlActualizarPropietario($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	INSPECTOR PROPIETARIO
	=============================================*/

	static public function mdlInspectorPropietario($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}


	/*=============================================
	BAJA PROPIETARIO
	=============================================*/

	static public function mdlBajaPropietario($tabla, $datos){
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET fec_baja=current_timestamp(),usuario=:usuario, estado='2' WHERE ci=:ci;");
	
		$stmt -> bindParam(":ci", $datos["ci"], PDO::PARAM_STR);
		$stmt -> bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	VALIDA CI DE PROPIETARIO
	=============================================*/

	static public function mdlValidaCiPropietario($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT ci FROM $tabla WHERE ci = :ciprop;");
		$stmt->bindParam(":ciprop", $datos["ciprop"], PDO::PARAM_STR);
		$stmt -> execute();

		$resultadopl = $stmt->fetch(PDO::FETCH_ASSOC); 
		return $resultadopl ? $resultadopl["ci"] : false;
		
		$stmt->close();
		$stmt = null;
	}


}