<?php

require_once "conexion.php";

class ModeloReporteApp{

	/*=============================================
	REPORTE DE VENTAS POR PARADA
	=============================================*/

	static public function mdlMostrarReporteParada($tabla, $datos){

			$stmt = Conexion::conectar()->prepare("SELECT vtx.idTicket, vtx.Placa, vtx.Costo, vtx.Fecha, vtx.Hora, vtx.Conductor, vtx.Parada, us.NombreApp FROM $tabla vtx INNER JOIN tx_usuriosSindicato us ON vtx.UsuarioCod = us.Password WHERE vtx.parada like :parada AND vtx.fecha BETWEEN :fechaInicio AND :fechaFin ORDER BY vtx.idTicket asc");
			//$stmt = Conexion::conectar()->prepare("SELECT idTicket, Placa, Costo, Fecha, Hora, Conductor, Parada, UsuarioCod FROM $tabla WHERE parada like :parada AND fecha BETWEEN :fechaInicio AND :fechaFin ORDER BY idTicket asc");
			$stmt->bindParam(":parada", $datos["rep1Parada"], PDO::PARAM_STR);
			$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
			$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
			
            // Ejecutar la consulta
            $stmt -> execute();

            // Devolver todos los resultados como un array
            return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
            echo("<script>console.log('PHP: " . $tabla . "');</script>");
		    $stmt -> close();
		    $stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS POR PLACA
	=============================================*/

	static public function mdlMostrarReportePlaca($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT idTicket, Placa, Costo, Fecha, Hora, Conductor, Parada, UsuarioCod FROM $tabla WHERE Placa = :placa AND fecha BETWEEN :fechaInicio AND :fechaFin ORDER BY idTicket, fecha asc");
		$stmt->bindParam(":placa", $datos["repPlaca"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		echo("<script>console.log('PHP: " . $tabla . "');</script>");
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS POR GRUPO
	=============================================*/

	static public function mdlMostrarReporteGrupo($datos){

		$stmt = Conexion::conectar()->prepare("SELECT 
												vt.idTicket, 
												vt.Placa, 
												vt.Costo, 
												vt.Fecha, 
												vt.Hora, 
												vt.Conductor, 
												vt.Parada,
												v.grupo 
											FROM 
												tx_ventatickets vt
											JOIN 
												tx_vehiculos v ON vt.Placa = v.Placa
											WHERE 
												v.grupo = :subgrupo and vt.Fecha between :fechaInicio and :fechaFin order by vt.idTicket, vt.fecha asc;");
		$stmt->bindParam(":subgrupo", $datos["repSubgrupo"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		echo("<script>console.log('PHP: " . $tabla . "');</script>");
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS TOTALIZADO POR GRUPO
	=============================================*/

	static public function mdlMostrarReporteTotalGrupo($datos){

		$stmt = Conexion::conectar()->prepare("SELECT 
												sum(vt.Costo) as TotalCosto, 
												v.grupo 
											FROM 
												tx_ventatickets vt
											JOIN 
												tx_vehiculos v ON vt.Placa = v.Placa
											WHERE 
												vt.Fecha between :fechaInicio and :fechaFin group by v.grupo;");		
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		echo("<script>console.log('PHP: " . $tabla . "');</script>");
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS POR DIGITO
	=============================================*/

	static public function mdlMostrarReporteDigito($datos){

		$stmt = Conexion::conectar()->prepare("SELECT 
												vt.idTicket, 
												vt.Placa, 
												vt.Costo, 
												vt.Fecha, 
												vt.Hora, 
												vt.Conductor, 
												vt.Parada,
												v.digito_restriccion
											FROM 
												tx_ventatickets vt
											JOIN 
												tx_vehiculos v ON vt.Placa = v.Placa
											WHERE 
												v.digito_restriccion = :digito and vt.Fecha between :fechaInicio and :fechaFin order by vt.idTicket, vt.fecha asc;");
		$stmt->bindParam(":digito", $datos["repdigito"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		echo("<script>console.log('PHP: " . $tabla . "');</script>");
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS POR DIA
	=============================================*/

	static public function mdlMostrarReporteDia($datos){

		$stmt = Conexion::conectar()->prepare("SELECT 
												vt.idTicket, 
												vt.Placa, 
												vt.Costo, 
												vt.Fecha, 
												vt.Hora, 
												vt.Conductor, 
												vt.Parada,
												v.dia_restriccion
											FROM 
												tx_ventatickets vt
											JOIN 
												tx_vehiculos v ON vt.Placa = v.Placa
											WHERE 
												v.dia_restriccion = :dia and vt.Fecha between :fechaInicio and :fechaFin order by vt.idTicket, vt.fecha asc;");
		$stmt->bindParam(":dia", $datos["repdia"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS POR AGENTE
	=============================================*/

	static public function mdlMostrarReporteAgente($datos){

		$stmt = Conexion::conectar()->prepare("SELECT 
												vt.idTicket, 
												vt.Placa, 
												vt.Costo, 
												vt.Fecha, 
												vt.Hora, 
												vt.Conductor, 
												vt.Parada,
												v.NombreApp 
											FROM 
												tx_ventatickets vt
											JOIN 
												tx_usuriosSindicato v ON vt.UsuarioCod = v.Password 
											WHERE 
												v.NombreApp = :agepar and v.estado = '1' and vt.Fecha between :fechaInicio and :fechaFin order by vt.idTicket, vt.fecha asc;");
		$stmt->bindParam(":agepar", $datos["agepar"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE VENTAS POR EQUIPO
	=============================================*/

	static public function mdlMostrarReporteEquipo($datos){

		$stmt = Conexion::conectar()->prepare("SELECT 
												vt.idTicket, 
												vt.Placa, 
												vt.Costo, 
												vt.Fecha, 
												vt.Hora, 
												vt.Conductor, 
												vt.Parada,
												v.ModCelular 
											FROM 
												tx_ventatickets vt
											JOIN 
												tx_usuriosSindicato v ON vt.UsuarioCod = v.Password 
											WHERE 
												v.ModCelular = :equipo and v.estado = '1' and vt.Fecha between :fechaInicio and :fechaFin order by vt.idTicket, vt.fecha asc;");
		$stmt->bindParam(":equipo", $datos["equipo"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE AGENTES Y DISPOSITIVOS
	=============================================*/

	static public function mdlMostrarReporteAgenDispo($datos){
		//select NombreApp, ModCelular,Parada,IMEI from tx_usuriosSindicato tu where estado = :estado;
		$stmt = Conexion::conectar()->prepare("SELECT NombreApp, ModCelular,Parada,IMEI FROM tx_usuriosSindicato WHERE estado = :estado");
		$stmt->bindParam(":estado", $datos["agdi"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	RECUPERA AGENTES
	=============================================*/

	static public function mdlMostrarAgente($tipo){
		if ($tipo == "AGENTE"){
			$stmt = Conexion::conectar()->prepare("SELECT NombreApp FROM tx_usuriosSindicato WHERE estado = '1' group by NombreApp");
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT ModCelular FROM tx_usuriosSindicato WHERE estado = '1' group by NombreApp");
		}
			$stmt -> execute();
			return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}
}