<?php

require_once "conexion.php";

class ModeloReporteArchivo{


	/*=============================================
	REPORTE DE ALTAS y BAJAS DE HERRMIENTAS TRABAJO
	=============================================*/

	static public function mdlMostrarRepAltasBajasHerr($tipo,$datos){

		if ($tipo == "ALTAS"){
			$stmt = Conexion::conectar()->prepare("SELECT Nombre,Placa,Mensual,procedencia_linea,tipo,marca,color,modelo,digito_restriccion,dia_restriccion,grupo from tx_vehiculos tv where tv.estado = '1' and tv.fec_alta between :fechaInicio and :fechaFin");
		}
		if ($tipo == "BAJAS"){
			$stmt = Conexion::conectar()->prepare("SELECT Nombre,Placa,Mensual,procedencia_linea,tipo,marca,color,modelo,digito_restriccion,dia_restriccion,grupo from tx_vehiculos tv where tv.estado = '2' and tv.fec_baja between :fechaInicio and :fechaFin;");
		}
		
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE BAJAS
	=============================================*/

	static public function mdlMostrarReporteBajas($tipo,$datos){

		if ($tipo == "SOCIOS"){
			$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular FROM tx_propietarios tp where tp.estado = '2' and tp.fec_baja between :fechaInicio and :fechaFin;");
		}
		if ($tipo == "ASALARIADOS"){
			$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular FROM tx_asalariados ta where ta.estado = '2' and ta.fecha_baja between :fechaInicio and :fechaFin;");
		}
		
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE ALTAS
	=============================================*/

	static public function mdlMostrarReporteAltas($tipo,$datos){

		if ($tipo == "SOCIOS"){
			$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle FROM tx_propietarios tp where tp.estado = '1' and tp.fec_alta between :fechaInicio and :fechaFin;");
		}
		if ($tipo == "ASALARIADOS"){
			$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle FROM tx_asalariados ta where ta.estado = '1' and ta.fecha_alta between :fechaInicio and :fechaFin;");
		}
		
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE MODIFICACIONES
	=============================================*/

	static public function mdlMostrarReporteModificaciones($tipo,$datos){

		if ($tipo == "SOCIOS"){
			$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle FROM tx_propietarios tp where tp.estado = '1' and tp.fec_modif between :fechaInicio and :fechaFin;");
		}
		if ($tipo == "ASALARIADOS"){
			$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle FROM tx_asalariados ta where ta.estado = '1' and ta.fecha_mod between :fechaInicio and :fechaFin;");
		}
		
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE LISTADO DE ASALARIADOS
	=============================================*/

	static public function mdlMostrarReporteAsalariados($datos){
		$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,nombre_garante,direc_zona,direc_calle FROM tx_asalariados WHERE estado = :estado");
		$stmt->bindParam(":estado", $datos["estado"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE FILE PROPIETARIO
	=============================================*/

	static public function mdlMostrarReporteFilePro($datos){
		$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle,antecedentes,permiso FROM tx_propietarios WHERE ci = :ci");
		$stmt->bindParam(":ci", $datos["ci"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE FILE ASALARIADO
	=============================================*/

	static public function mdlMostrarReporteFileAsa($datos){
		$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle,antecedentes,permiso,nombre_garante FROM tx_asalariados WHERE ci = :ci");
		$stmt->bindParam(":ci", $datos["ci"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	FILE DE VEHICULOS
	=============================================*/

	static public function mdlMostrarFileVehiculos($datos){

		$stmt = Conexion::conectar()->prepare("SELECT Nombre,Placa,Mensual,procedencia_linea,tipo,marca,color,modelo,digito_restriccion,dia_restriccion,grupo from tx_vehiculos tv where tv.estado = '1' and tv.ci = :ci order by id");
		
		$stmt->bindParam(":ci", $datos["ci"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	LISTADO GENERAL DE VEHICULOS
	=============================================*/

	static public function mdlMostrarListaVehiculos($datos){

		$stmt = Conexion::conectar()->prepare("SELECT Nombre,Placa,Mensual,procedencia_linea,tipo,marca,color,modelo,digito_restriccion,dia_restriccion,grupo from tx_vehiculos tv where tv.estado = :estado order by id");
		
		$stmt->bindParam(":estado", $datos["estado"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE LISTADO DE SOCIOS
	=============================================*/

	static public function mdlMostrarReporteSocios($datos){
		$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,direc_zona,direc_calle FROM tx_propietarios WHERE estado = :estado");
		$stmt->bindParam(":estado", $datos["estado"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE LISTADO DE GARANTES
	=============================================*/

	static public function mdlMostrarReporteGarantes(){
		$stmt = Conexion::conectar()->prepare("SELECT ci,nombres,apellidos,fec_ingreso,celular,nombre_garante FROM tx_asalariados");
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}
}