<?php

require_once "conexion.php";

class ModeloReporteDeudas{

	/*=============================================
	MOSTRAR SOCIOS
	=============================================*/

	static public function MdlMostrarSocios(){

			$stmt = Conexion::conectar()->prepare("SELECT nombre_completo FROM vw_prop_asa ORDER BY nombre_completo ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	RECUPERA RUBROS
	=============================================*/

	static public function mdlMostrarRubrosDeudas(){
		$stmt = Conexion::conectar()->prepare("SELECT rubro FROM tx_listadorubros WHERE refmodeuda = 'S' and estado = '1' and men = '0' GROUP BY rubro");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	RECUPERA RUBROS MENSUALES ** NO BORRAR **
	=============================================*/

	static public function mdlMostrarRubrosMensuales(){
		$stmt = Conexion::conectar()->prepare("SELECT rubro FROM tx_rubromensual WHERE estado = '1' GROUP BY rubro");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================

	=============================================*/

	static public function mdlMostrarDeudaGeneralEstado($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT Disciplina, Equipo1, Res1, Equipo2,Res2,estado
												FROM `tx_evento` 
												where estado = :repestadode and fecha BETWEEN :fechaInicio and :fechaFin;");

		$stmt->bindParam(":repestadode", $datos["repestadode"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}



	static public function mdlMostrarApuestasreporte($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT Equipo1,Res1,Equipo2,Res2,Fecha,monto,usuario 
											FROM `tx_apuestas` 
											where Equipo1 = :Requipo1 and Res1 = :Rres1 and Equipo2 = :Requipo2 and Res2 = :Rres2
											and Fecha BETWEEN :fechaInicio and :fechaFin;");

		$stmt->bindParam(":Requipo1", $datos["Requipo1"], PDO::PARAM_STR);
		$stmt->bindParam(":Rres1", $datos["Rres1"], PDO::PARAM_STR);
		$stmt->bindParam(":Requipo2", $datos["Requipo2"], PDO::PARAM_STR);
		$stmt->bindParam(":Rres2", $datos["Rres2"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE DEUDAS X ITEM
	=============================================*/

	static public function mdlMostrarReporteDeudasRubro($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT p.ci, p.nombre_completo, a.fechareg,a.estado,a.rubro, a.descripcion ,SUM(cuotas) as total 
												FROM tx_deudas a
												JOIN vw_prop_asa p ON a.ci = p.ci
												WHERE a.rubro = :reprubrode and a.fechareg between :fechaInicio and :fechaFin 
												GROUP BY p.ci,p.nombre_completo,a.fechareg,a.estado,a.rubro, a.descripcion
												ORDER BY cod_deuda ASC");
		$stmt->bindParam(":reprubrode", $datos["reprubrode"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE DEUDAS X SOCIO
	=============================================*/

	static public function mdlMostrarDeudaSocio($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT d.cod_deuda, d.fechareg, d.rubro, d.descripcion, SUM(d.cuotas) as total 
												FROM tx_deudas d 
												JOIN vw_prop_asa p 
												ON d.ci = p.ci
												where p.nombre_completo = :repsociode and d.estado <> 'CANCELADO' and d.estado <> 'ANULADO' and d.fechareg between :fechaInicio and :fechaFin
												group by d.cod_deuda, d.fechareg, d.rubro, d.descripcion;");
		$stmt->bindParam(":repsociode", $datos["repsociode"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE DEUDAS DETALLE X SOCIO
	=============================================*/

	static public function mdlMostrarDetalleDeudaSocio($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT d.cod_deuda, d.rubro, d.cuotas, d.fec_vence, d.fecpago, d.estado
												FROM tx_deudas d
												JOIN vw_prop_asa p 
												ON d.ci = p.ci
												where p.nombre_completo = :repsociode and d.estado <> 'ANULADO'and d.fechareg between :fechaInicio and :fechaFin;");
		$stmt->bindParam(":repsociode", $datos["repsociode"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}


	/*=============================================
	REPORTE COMPROMISO DE PAGO
	=============================================*/

	static public function mdlMostrarDetalleDeuda($datos){

		$stmt = Conexion::conectar()->prepare("SELECT d.cod_deuda, d.rubro, d.cuotas, d.fec_vence, d.fecpago, d.estado, p.ci_garante, p.nombre_garante 
												FROM tx_deudas d
												JOIN vw_prop_asa p 
												ON d.ci = p.ci
												where d.cod_deuda = :repcoddeuda;");
		$stmt->bindParam(":repcoddeuda", $datos["repcoddeuda"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	MOSTRAR DATOS SOCIO REPORTE DEUDA ** SOLO SOCIO
	=============================================*/

	static public function MdlMostrarDatosSocio($socio){

		$stmt = Conexion::conectar()->prepare("SELECT ci,nombre_completo,celular FROM vw_prop_asa WHERE nombre_completo = :sociode");
		$stmt->bindParam(":sociode", $socio, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();

	$stmt -> close();

	$stmt = null;

   }

}