<?php

require_once "conexion.php";

class ModeloIngresosEgresos{

	/*=============================================
	MOSTRAR SOCIOS
	=============================================*/

	static public function MdlMostrarSocios(){

			$stmt = Conexion::conectar()->prepare("SELECT nombre_completo FROM vw_prop_asa ORDER BY nombre_completo ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	RECUPERA RUBROS
	=============================================*/

	static public function mdlMostrarRubros(){
		$stmt = Conexion::conectar()->prepare("SELECT rubro FROM tx_listadorubros WHERE estado = '1' and men = '0' GROUP BY rubro");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE INGRESOS
	=============================================*/

	static public function mdlMostrarReporteIngresos($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT ci,nroing,fecha,rubro,detalle,SUM(subtotal) as subtotal,nombre,celular,tipocomp FROM $tabla WHERE estado = '1' and fecha between :fechaInicio and :fechaFin GROUP BY ci,nroing,fecha,rubro,detalle,nombre,celular,tipocomp ORDER BY nroing ASC");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}
	
	/*=============================================
	REPORTE DE INGRESOS GENERAL POR RUBRO
	=============================================*/

	static public function mdlMostrarReporteIngresosGeneral($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT rubro, SUM(subtotal) as subtotal 
FROM $tabla 
WHERE estado = '1' and fecha between :fechaInicio and :fechaFin 
GROUP BY rubro 

UNION ALL

SELECT 'COBROS MENSUALES' AS rubro, SUM(monto) AS subtotal
FROM tx_mensualdetalle 
WHERE mes IN ('enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre') 
AND fechapago BETWEEN :fechaInicio and :fechaFin

UNION ALL

SELECT 'COBROS MENSUALES VARIOS' AS rubro, SUM(monto) AS subtotal
FROM tx_mensualdetalle 
WHERE mes NOT IN ('enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre') 
AND fechapago BETWEEN :fechaInicio and :fechaFin

ORDER BY rubro ASC;");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE EGRESOS
	=============================================*/

	static public function mdlMostrarReporteEgresos($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT ci,nroing,fecha,rubro,detalle,SUM(subtotal) as subtotal,nombre,celular,tipocomp FROM $tabla WHERE estado = '1' and fecha between :fechaInicio and :fechaFin GROUP BY ci,nroing,fecha,rubro,detalle,nombre,celular,tipocomp ORDER BY nroing ASC");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE EGRESOS GENERAL POR RUBRO
	=============================================*/

	static public function mdlMostrarReporteEgresosGeneral($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT rubro,SUM(subtotal) as subtotal FROM $tabla WHERE estado = '1' and fecha between :fechaInicio and :fechaFin GROUP BY rubro ORDER BY rubro ASC");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}


	/*=============================================
	REPORTE DE INGRESOS Y EGRESOS X ITEM
	=============================================*/

	static public function mdlMostrarReporteIngEgr($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT ci,nroing,fecha,rubro,detalle,SUM(subtotal) as subtotal, nombre FROM $tabla WHERE rubro = :reprubroie and estado = '1' and fecha between :fechaInicio and :fechaFin GROUP BY ci,nroing,fecha,rubro,detalle,nombre ORDER BY nroing ASC");
		$stmt->bindParam(":reprubroie", $datos["reprubroie"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE DE INGRESOS Y EGRESOS X SOCIO
	=============================================*/

	static public function mdlMostrarReporteIngEgrSocio($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT ci,nroing,fecha,rubro,detalle,SUM(subtotal) as subtotal FROM $tabla WHERE nombre = :repsocioie and estado = '1' and fecha between :fechaInicio and :fechaFin GROUP BY ci,nroing,fecha,rubro,detalle ORDER BY nroing ASC");
		$stmt->bindParam(":repsocioie", $datos["repsocioie"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE GENERAL INGRESOS Y EGRESOS
	=============================================*/

	static public function mdlMostrarReporteGeneral($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT CASE 
        WHEN MONTH(fecha) = 1 THEN 'ENERO'
        WHEN MONTH(fecha) = 2 THEN 'FEBRERO'
        WHEN MONTH(fecha) = 3 THEN 'MARZO'
        WHEN MONTH(fecha) = 4 THEN 'ABRIL'
        WHEN MONTH(fecha) = 5 THEN 'MAYO'
        WHEN MONTH(fecha) = 6 THEN 'JUNIO'
        WHEN MONTH(fecha) = 7 THEN 'JULIO'
        WHEN MONTH(fecha) = 8 THEN 'AGOSTO'
        WHEN MONTH(fecha) = 9 THEN 'SEPTIEMBRE'
        WHEN MONTH(fecha) = 10 THEN 'OCTUBRE'
        WHEN MONTH(fecha) = 11 THEN 'NOVIEMBRE'
        WHEN MONTH(fecha) = 12 THEN 'DICIEMBRE'
    END as mes, SUM(subtotal) as total FROM $tabla WHERE estado = '1' and fecha between :fechaInicio and :fechaFin GROUP BY mes ORDER BY MONTH(fecha)");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE GENERAL OBTIENE SALDO ANTERIOR PARA REPORTE GENERAL
	=============================================*/

	static public function mdlObtieneSaldoAnt($datos){
 
		$stmt = Conexion::conectar()->prepare("SELECT tc.saldocaja AS saldoanterior FROM tx_cierrediario tc WHERE tc.fecha = (SELECT MAX(tc2.fecha) FROM tx_cierrediario tc2 WHERE tc2.fecha < :fechaInicio)");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE GENERAL OBTIENE INGRESOS MENSUALES PARA REPORTE GENERAL
	=============================================*/

	static public function mdlMostrarReporteGeneral2($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT SUM(subtotal) as total FROM $tabla WHERE estado = '1' and fecha between :fechaInicio and :fechaFin");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE GENERAL INGRESOS Y EGRESOS
	=============================================*/

	static public function mdlMostrarReporteGeneralmensuales($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT SUM(monto) as total FROM $tabla WHERE fechapago between :fechaInicio and :fechaFin");
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

}