<?php

require_once "conexion.php";

class ModeloReporteMensual{

	/*=============================================
	MOSTRAR SOCIOS
	=============================================*/

	static public function MdlMostrarSocios(){

			$stmt = Conexion::conectar()->prepare("SELECT nombre_completo FROM vw_prop_asa ORDER BY nombre_completo ASC");
			$stmt -> execute();
			return $stmt -> fetchAll();

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	RECUPERA RUBROS VARIOS
	=============================================*/

	static public function mdlMostrarRubrosMensual(){
		$stmt = Conexion::conectar()->prepare("SELECT rubro FROM tx_rubromensual WHERE estado = '1' and tipo = 'VARIOS' GROUP BY rubro");
		$stmt -> execute();
		return $stmt -> fetchAll();
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE MENSUAL DE ESTADOS MES
	=============================================*/

	static public function mdlMostrarMensualGeneralEstado($datos){

		$stmt = Conexion::conectar()->prepare("SELECT r.rubro AS rubro, COALESCE(d.monto, 0) AS monto, v.nombre_completo 
												FROM 
													tx_rubromensual r 
												CROSS JOIN 
													vw_prop_asa v  
												LEFT JOIN 
													tx_mensualdetalle d ON r.rubro = d.mes AND d.ci = v.ci 
												WHERE 
													r.gestion = YEAR(CURDATE()) 
												AND 
													r.estado = '1' 
												AND 
													r.tipo = 'MENSUAL' 
												AND 
													v.tp like :repestadomen
												AND
													d.fechapago between :fechaini and :fechafin
												ORDER BY 
													v.nombre_completo, 
													FIELD(r.rubro, 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');");
		$stmt->bindParam(":repestadomen", $datos["repestadomen"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaini", $datos["FechaIni"], PDO::PARAM_STR);
		$stmt->bindParam(":fechafin", $datos["FechaFin"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE MENSUAL MUESTRA LOS USUARIOS DATOS DE BAJA
	=============================================*/

	static public function mdlMostrarBajasMensual($datos){

		$stmt = Conexion::conectar()->prepare("SELECT r.rubro AS rubro, COALESCE(d.monto, 0) AS monto, v.nombre_completo 
												FROM 
													tx_rubromensual r 
												CROSS JOIN 
													vw_prop_asa_rpmensual v  
												LEFT JOIN 
													tx_mensualdetalle d ON r.rubro = d.mes AND d.ci = v.ci 
												WHERE 
													r.gestion = YEAR(CURDATE()) 
												AND 
													r.estado = '1' 
												AND 
													r.tipo = 'MENSUAL' 
												AND 
													v.tp like :repestadomen
												AND
													d.fechapago between :fechaini and :fechafin
												ORDER BY 
													v.nombre_completo, 
													FIELD(r.rubro, 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');");
		$stmt->bindParam(":repestadomen", $datos["repestadomen"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaini", $datos["FechaIni"], PDO::PARAM_STR);
		$stmt->bindParam(":fechafin", $datos["FechaFin"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE MENSUAL DE ESTADOS VARIOS
	=============================================*/

	static public function mdlMostrarMensualGeneralEstadoVar($datos){

		$stmt = Conexion::conectar()->prepare("SELECT r.rubro AS rubro, COALESCE(d.monto, 0) AS monto, v.nombre_completo 
												FROM 
													tx_rubromensual r 
												CROSS JOIN 
													vw_prop_asa v  
												LEFT JOIN 
													tx_mensualdetalle d ON r.rubro = d.mes AND d.ci = v.ci 
												WHERE 
													r.gestion = YEAR(CURDATE()) 
												AND 
													r.estado = '1' 
												AND 
													r.tipo = 'VARIOS' 
												AND 
													v.tp like :repestadomen
												AND
													d.fechapago between :fechaini and :fechafin
												ORDER BY 
													v.nombre_completo, 
													FIELD(r.rubro, 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');");
		$stmt->bindParam(":repestadomen", $datos["repestadomen"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaini", $datos["FechaIni"], PDO::PARAM_STR);
		$stmt->bindParam(":fechafin", $datos["FechaFin"], PDO::PARAM_STR);
		// Ejecutar la consulta
		$stmt -> execute();
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}


	/*=============================================
	REPORTE MENSUAL MUESTRA VARIOS DE USUARIOS DADOS BAJA
	=============================================*/

	static public function mdlMostrarBajasMensualVarios($datos){

		$stmt = Conexion::conectar()->prepare("SELECT r.rubro AS rubro, COALESCE(d.monto, 0) AS monto, v.nombre_completo 
												FROM 
													tx_rubromensual r 
												CROSS JOIN 
													vw_prop_asa_rpmensual v  
												LEFT JOIN 
													tx_mensualdetalle d ON r.rubro = d.mes AND d.ci = v.ci 
												WHERE 
													r.gestion = YEAR(CURDATE()) 
												AND 
													r.estado = '1' 
												AND 
													r.tipo = 'VARIOS' 
												AND 
													v.tp like :repestadomen
												AND
													d.fechapago between :fechaini and :fechafin
												ORDER BY 
													v.nombre_completo, 
													FIELD(r.rubro, 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');");
		$stmt->bindParam(":repestadomen", $datos["repestadomen"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaini", $datos["FechaIni"], PDO::PARAM_STR);
		$stmt->bindParam(":fechafin", $datos["FechaFin"], PDO::PARAM_STR);
		// Ejecutar la consulta
		$stmt -> execute();
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}


	/*=============================================
	REPORTE MENSUAL MOSTRAR MESES
	=============================================*/

	static public function mdlMostrarMeses($datos){

		$stmt = Conexion::conectar()->prepare("SELECT r.rubro, d.fechapago, d.nrorecibo, d.monto,  IFNULL(d.observaciones,'PENDIENTE') AS observaciones  
									FROM tx_rubromensual r 
									LEFT JOIN tx_mensualdetalle d ON r.rubro = d.mes AND d.gestion = :repgestion AND d.ci = (
										SELECT ci 
										FROM vw_prop_asa 
										WHERE nombre_completo = :repsociomen)
									WHERE r.gestion = :repgestion and r.estado = '1' and r.tipo = 'MENSUAL' 
									ORDER BY FIELD(r.rubro, 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');");
		$stmt->bindParam(":repsociomen", $datos["repsociomen"], PDO::PARAM_STR);
		$stmt->bindParam(":repgestion", $datos["repgestion"], PDO::PARAM_STR);
				
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REPORTE MENSUAL MOSTRAR VARIOS AYUDAS
	=============================================*/

	static public function mdlMostrarVarios($datos){

		$stmt = Conexion::conectar()->prepare("SELECT r.rubro, d.fechapago, d.nrorecibo, d.monto,  IFNULL(d.observaciones,'PENDIENTE') AS observaciones  
												FROM tx_rubromensual r 
												LEFT JOIN tx_mensualdetalle d ON r.rubro = d.mes AND d.gestion = :repgestion AND d.ci = (
													SELECT ci 
													FROM vw_prop_asa 
													WHERE nombre_completo = :repsociomen
													)
												WHERE r.gestion = :repgestion and r.estado = '1' and r.tipo = 'VARIOS' 
												ORDER BY r.rubro DESC;");
		$stmt->bindParam(":repsociomen", $datos["repsociomen"], PDO::PARAM_STR);
		$stmt->bindParam(":repgestion", $datos["repgestion"], PDO::PARAM_STR);		
		// Ejecutar la consulta
		$stmt -> execute();
		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;
	}

	/*=============================================
	REPORTE MENSUAL MOSTRAR DATOS SOCIO 
	=============================================*/

	static public function MdlMostrarDatosSocio($socio){

		$stmt = Conexion::conectar()->prepare("SELECT ci,nombre_completo,celular,placa,tp FROM vw_prop_asa WHERE nombre_completo = :sociode");
		$stmt->bindParam(":sociode", $socio, PDO::PARAM_STR);
		$stmt -> execute();
		return $stmt -> fetchAll();

	$stmt -> close();

	$stmt = null;

   }

   	/*=============================================
	REPORTE DE MENSUAL X RUBRO
	=============================================*/

	static public function mdlMostrarReporteMensualRubro($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("SELECT p.nombre_completo, d.fechapago, d.nrorecibo, SUM(d.monto) as monto
												FROM tx_mensualdetalle d
												JOIN vw_prop_asa p ON d.ci = p.ci
												where d.fechapago between :fechaInicio and :fechaFin and observaciones = 'PAGADO' and mes = :reprubromen
												group by p.nombre_completo, d.fechapago, d.nrorecibo;");
		$stmt->bindParam(":reprubromen", $datos["reprubromen"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaInicio", $datos["fechaInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":fechaFin", $datos["fechaFin"], PDO::PARAM_STR);
		
		// Ejecutar la consulta
		$stmt -> execute();

		// Devolver todos los resultados como un array
		return $stmt -> fetchAll(PDO::FETCH_ASSOC); // Cambiado de fetch() a fetchAll()
		$stmt -> close();
		$stmt = null;

	}

}