/*=============================================
EDITAR AGENTE
=============================================*/
$(document).on("click", ".btnEditarAgente", function(){

	var idAgente = $(this).attr("idAgente");
	
	var datos = new FormData();
	datos.append("idAgente", idAgente);

	$.ajax({

		url:"ajax/agentesdisp.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			
			$("#editarId").val(respuesta["id"]);
			$("#editarNombre").val(respuesta["NombreApp"]);
			$("#editarNumero").val(respuesta["Numero"]);
			$("#editarModelo").val(respuesta["ModCelular"]);
			$("#editarKey").val(respuesta["IMEI"]);
			$("#editarParada").html(respuesta["Parada"]);
			$("#editarParada").val(respuesta["Parada"]);
			
			$("#passwordActual").val(respuesta["Password"]);

		}

	});

})


/*=============================================
ACTIVAR AGENTE Y DISPOSITIVO
=============================================*/
$(document).on("click", ".btnActivarAgente", function(){

	var idAgedisp = $(this).attr("idAgedisp");
	var estadoAgedisp = $(this).attr("estadoAgedisp");

	var datos = new FormData();
 	datos.append("idAgedisp", idAgedisp);
  	datos.append("estadoAgedisp", estadoAgedisp);

  	$.ajax({

	  url:"ajax/agentesdisp.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      	if(window.matchMedia("(max-width:767px)").matches){
		
			Swal.fire({
		      	title: "El Agente y Dispositivo ha sido habilitado",
		      	type: "success",
		      	confirmButtonText: "¡Cerrar!"
		    	}).then(function(result) {
		        
		        	if (result.value) {

		        	window.location = "frmagentesdisp";

		        }

		      });
		}
      }

  	})

  	if(estadoAgedisp == 0){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('Desactivado');
  		$(this).attr('estadoAgedisp',1);

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('Activado');
  		$(this).attr('estadoAgedisp',0);

  	}

})

/*=============================================
REVISAR SI EL USUARIO YA ESTÁ REGISTRADO
=============================================*/

$("#nuevoUsuario").change(function(){

	$(".alert").remove();

	var usuario = $(this).val();

	var datos = new FormData();
	datos.append("validarUsuario", usuario);

	 $.ajax({
	    url:"ajax/usuarios.ajax.php",
	    method:"POST",
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
	    dataType: "json",
	    success:function(respuesta){
	    	
	    	if(respuesta){

	    		$("#nuevoUsuario").parent().after('<div class="alert alert-warning">Este usuario ya existe en la base de datos</div>');

	    		$("#nuevoUsuario").val("");

	    	}

	    }

	})
})

/*=============================================
ELIMINAR USUARIO
=============================================*/
$(document).on("click", ".btnEliminarAgente", function(){

  var idAgente = $(this).attr("idAgente");

  Swal.fire({
	icon: "warning",
    title: '¿Está seguro de eliminar el Dispositivo y Agente?',
    text: "¡Si no lo está puede cancelar la accíón!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, eliminar!'
  }).then(function(result){

    if(result.value){

      window.location = "index.php?ruta=frmagentesdisp&idAgente="+idAgente;

    }

  })

})

$(document).ready(function(){
    $('input[name="nuevoFecingreso"]').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' });
});


