/*=============================================
VER ANTECEDENTES
=============================================*/

$(document).on("click", ".btnVerantecedente", function(){

	var ciPropietarioAnt = $(this).attr("ciPropietarioAnt");
	
	var datos = new FormData();
	datos.append("ciPropietarioAnt", ciPropietarioAnt);

	$.ajax({

		url:"ajax/propietarios.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			$("#mostrarAntecedentes").val(respuesta["antecedentes"]);
			//var perant = respuesta["antecedentes"];
/* 			var perant = 'antecedentes';
			Swal.fire({
				title: `-: ${perant}`,
				icon: "error"
			  }); */
		}

	});

})

/*=============================================
VER PERMISOS
=============================================*/

$(document).on("click", ".btnVerpermiso", function(){

	var ciPropietarioPer = $(this).attr("ciPropietarioPer");
	
	var datos = new FormData();
	datos.append("ciPropietarioPer", ciPropietarioPer);

	$.ajax({

		url:"ajax/propietarios.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			$("#mostrarPermisos").val(respuesta["permiso"]);
/* 			var perpro = respuesta["permiso"];
			Swal.fire({
				title: `-: ${perpro}`,
				icon: "info"
			  }); */
		}

	});

})

 

/*=============================================
EDITAR PROPIETARIO
=============================================*/
$(document).on("click", ".btnEditarPropietario", function(){

	var ciPropietario = $(this).attr("ciPropietario").trim();

	var datos = new FormData();
	datos.append("ciPropietario", ciPropietario);

	 $.ajax({

		url:"ajax/propietarios.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			
			// Asumiendo que la fecha está en formato 'YYYY-MM-DD'
			var fechaIngreso = respuesta["Fecha"];
        
			if (fechaIngreso) {
				// Divide la fecha en partes
				var partesFecha = fechaIngreso.split("-");
				// Reorganiza las partes al formato 'DD/MM/YYYY'
				var fechaFormateada = partesFecha[2] + "/" + partesFecha[1] + "/" + partesFecha[0];
				// Asigna la fecha formateada al campo de fecha
				$("#editarFec").val(fechaFormateada);
			} else {
				$("#editarFec").val("");
			}
			
			$("#editarid").val(respuesta["id"]);
			$("#editardisciplina").val(respuesta["Disciplina"].trim());
			$("#editarEquipo1").val(respuesta["Equipo1"]);
			$("#editarRes1").val(respuesta["Res1"]);
			$("#editarEquipo2").val(respuesta["Equipo2"]);
			// $("#editarFecingreso").val(respuesta["fec_ingreso"]);
			$("#editarRes2").val(respuesta["Res2"]);
			$("#editarHora").val(respuesta["hora"]);
			$("#editarMonto").val(respuesta["Montoapuesta"]);
			$("#editarestado").val(respuesta["estado"]);
		}

	}); 

})

/*=============================================
ACTIVAR PROPIETARIO
=============================================*/
$(document).on("click", ".btnActivarProp", function(){

	var ciPropietarioAct = $(this).attr("ciPropietarioAct");
	var estadoPropietarioAct = $(this).attr("estadoPropietarioAct");

	var datos = new FormData();
 	datos.append("activarCI", ciPropietarioAct);
  	datos.append("activarPropietario", estadoPropietarioAct);

  	$.ajax({

	  url:"ajax/propietarios.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      	if(window.matchMedia("(max-width:767px)").matches){
		
			Swal.fire({
		      	title: "El propietario ha sido habilitado",
		      	type: "success",
		      	confirmButtonText: "¡Cerrar!"
		    	}).then(function(result) {
		        
		        	if (result.value) {

		        	window.location = "frmbajapropietarios";

		        }

		      });


		}
      }

  	})

  	if(estadoPropietarioAct == 0){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('Inactivo');
  		$(this).attr('estadoPropietarioAct',1);

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('Activo');
  		$(this).attr('estadoPropietarioAct',0);

  	}

})

/*=============================================
ASIGNAR INPECTOR
=============================================*/
$(document).on("click", ".btnInspectorProp", function(){

	var ciPropietariotp = $(this).attr("ciPropietariotp");
	var tpPropietario = $(this).attr("tpPropietario");

	var datos = new FormData();
 	datos.append("inspecCiPro", ciPropietariotp);
  	datos.append("inspecProTp", tpPropietario);

  	$.ajax({

	  url:"ajax/propietarios.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      	if(window.matchMedia("(max-width:767px)").matches){
		
			Swal.fire({
		      	title: "El propietario ha sido asignado como AUTORIDAD",
		      	type: "success",
		      	confirmButtonText: "¡Cerrar!"
		    	}).then(function(result) {
		        
		        	if (result.value) {

		        	window.location = "frmbajapropietarios";

		        }

		      });


		}
      }

  	})

  	if(tpPropietario == 'PRO'){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('NO');
  		$(this).attr('tpPropietario',"INS");

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('SI');
  		$(this).attr('tpPropietario',"PRO");

  	}

})

/*=============================================
Baja de Propietario
=============================================*/

$(document).on("click", ".btnbajaPropietario", function() {
    // Captura el valor del atributo placaVehiculo
    var ciPropietarioBaj = $(this).attr("ciPropietarioBaj");

    // Asigna el valor al input en el modal
    $("#editBajaProp").val(ciPropietarioBaj);
	 //console.log("CI del propietario:", ciPropietarioBaj);
    // Opcional: mostrar el input si estaba oculto
     // Abrir el modal (esto ocurre automáticamente si usas data-toggle="modal")
    //$("#modalbajaVechiculo").modal("show");
});