
/*=============================================
REPORTE APP
=============================================*/
$(document).on("click", ".btnGenerarReporte1", function(){

  var formatoreporte = $(this).attr("formatoreporte");	
  var fechaInicio = $('#fechaInicio').val();
  var fechaFin = $('#fechaFin').val();
  var tipoReporteApp = $('#tipoReporteApp').val();


  var parada = $('#cboParada').val();
  var txtPlaca = $('#txtPlaca').val();
  var cbosubgrupo = $('#cbosubgrupo').val();
  var cbodigito = $('#cbodigito').val();
  var cbodia = $('#cbodia').val();
  var cboagente = $('#cboagente').val();
  var cboimei = $('#cboimei').val();
   
  //console.log('PHP:', formatoreporte);
  //console.log('PHP:', fechaFin);
  //console.log('PHP:', parada);

  if (!fechaInicio || !fechaFin) {
	Swal.fire({
		icon: "warning",
		title: "¡Debe seleccionar una fecha de inicio y una fecha final!",
		showConfirmButton: true,
		confirmButtonText: "CERRAR"
	}).then((result) => {
		if (result.isConfirmed) {
			window.location = "frmreportesapp";
		}
	});
  }else{

	  // Convertir las fechas a objetos Date para comparar
	  var fechaInicioObj = new Date(fechaInicio);
	  var fechaFinObj = new Date(fechaFin);
	
	  // Validación de rango de fechas: fechaFin no debe ser mayor a fechaInicio
	  if (fechaFinObj < fechaInicioObj) {
		Swal.fire({
			icon: "warning",
			title: "¡La fecha de fin no puede ser menor que la fecha de inicio.!",
			showConfirmButton: true,
			confirmButtonText: "CERRAR"
		}).then((result) => {
			if (result.isConfirmed) {
				window.location = "frmreportesapp";
			}
		});

	  }else{
		if (formatoreporte =="pdf"){
			//////////// REPORTE EN PDF ////////////////
			switch (tipoReporteApp) {
				case "REP_PARADA":
					window.open("extensiones/tcpdf/pdf/reporteVParada.php?paradaRp="+parada+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_PLACA":
					window.open("extensiones/tcpdf/pdf/reporteVPlaca.php?placaRp="+txtPlaca+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_SUBGRUPO":
					window.open("extensiones/tcpdf/pdf/reporteVSubgrupo.php?subgrupoRp="+cbosubgrupo+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_DIGITO":
					window.open("extensiones/tcpdf/pdf/reporteVDigito.php?digitoRp="+cbodigito+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_DIA":
					window.open("extensiones/tcpdf/pdf/reporteVDia.php?diaRp="+cbodia+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_VAGENTE":
					window.open("extensiones/tcpdf/pdf/reporteVAgente.php?ageparRp="+cboagente+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
					break;
				case "REP_IMEI":
					window.open("extensiones/tcpdf/pdf/reporteVEquipo.php?equipoRp="+cboimei+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
					break;
				case "REP_AGENTESEQUIPOS":
					window.open("extensiones/tcpdf/pdf/reporteAgenEquip.php?agdiRp=1","_blank");
					break;
				case "REP_SUBGRUPOTOTAL":
					window.open("extensiones/tcpdf/pdf/reporteVSubgrupoTotal.php?fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
					break;
				case "REP_INASISTENCIAS":
					//console.log("Tengo un loro");
					break;
			}
			
		}else{
			//////////// REPORTE EN EXCEL /////////////
			switch (tipoReporteApp) {
				case "REP_PARADA":
					window.open("vistas/modulos/rptExcelParada.php?paradaRp="+parada+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_PLACA":
				  console.log("Tengo un perro");
				  break;
				case "REP_SUBGRUPO":
				  console.log("Tengo un gato");
				  break;
				case "REP_DIGITO":
				  console.log("Tengo una serpiente");
				  break;
				case "REP_DIA":
				  console.log("Tengo un loro");
				  break;
				case "REP_VAGENTE":
				  console.log("Tengo un gato");
					break;
				case "REP_IMEI":
					console.log("Tengo una serpiente");
					break;
				case "REP_AGENTESPARADA":
					console.log("Tengo un loro");
					break;
				case "REP_INASISTENCIAS":
					console.log("Tengo un loro");
					break;
			}
			
		}
	  }
  }  
})

/*=============================================
REPORTE APP EXCEL
=============================================*/
$(document).on("click", ".btnGenerarReporteExcel", function(){

	var formatoreporte = $(this).attr("formatoreporte");	
	var fechaInicio = $('#fechaInicio').val();
	var fechaFin = $('#fechaFin').val();
	var tipoReporteApp = $('#tipoReporteApp').val();
  
  
	var parada = $('#cboParada').val();
	   
	if (!fechaInicio || !fechaFin) {
	  Swal.fire({
		  icon: "warning",
		  title: "¡Debe seleccionar una fecha de inicio y una fecha final!",
		  showConfirmButton: true,
		  confirmButtonText: "CERRAR"
	  }).then((result) => {
		  if (result.isConfirmed) {
			  window.location = "frmreportesapp";
		  }
	  });
	}else{
  
		// Convertir las fechas a objetos Date para comparar
		var fechaInicioObj = new Date(fechaInicio);
		var fechaFinObj = new Date(fechaFin);
	  
		// Validación de rango de fechas: fechaFin no debe ser mayor a fechaInicio
		if (fechaFinObj < fechaInicioObj) {
		  Swal.fire({
			  icon: "warning",
			  title: "¡La fecha de fin no puede ser menor que la fecha de inicio.!",
			  showConfirmButton: true,
			  confirmButtonText: "CERRAR"
		  }).then((result) => {
			  if (result.isConfirmed) {
				  window.location = "frmreportesapp";
			  }
		  });
  
		}else{
		  if (formatoreporte =="excel"){
			  //////////// REPORTE EN EXCEL /////////////
			  switch (tipoReporteApp) {
				  case "REP_PARADA":
					  window.open("vistas/modulos/rptExcelParada.php?paradaRp="+parada+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
					break;
				  case "REP_PLACA":
					console.log("Tengo un perro");
					break;
				  case "REP_SUBGRUPO":
					console.log("Tengo un gato");
					break;
				  case "REP_DIGITO":
					console.log("Tengo una serpiente");
					break;
				  case "REP_DIA":
					console.log("Tengo un loro");
					break;
				  case "REP_VAGENTE":
					console.log("Tengo un gato");
					  break;
				  case "REP_IMEI":
					  console.log("Tengo una serpiente");
					  break;
				  case "REP_AGENTESPARADA":
					  console.log("Tengo un loro");
					  break;
				  case "REP_INASISTENCIAS":
					  console.log("Tengo un loro");
					  break;
			  }
			  
		  }
		}
	}  
  })

$(document).ready(function(){
    $('input[name="nuevoFecingreso"]').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' });
});

/*=============================================
DATEPICKET
=============================================*/

  $(document).ready(function() {
    $('.datepicker').datepicker({
      format: 'yyyy-mm-dd',
      autoclose: true
    });
    // Obtener la fecha local actual
    var today = new Date();
    var year = today.getFullYear();
    var month = String(today.getMonth() + 1).padStart(2, '0'); // Meses comienzan desde 0
    var day = String(today.getDate()).padStart(2, '0'); // Día del mes

    var formattedDate = year + '-' + month + '-' + day; // Formato yyyy-mm-dd

	$('#fechaInicio').val(formattedDate); // Asigna la fecha actual al campo "fechaInicio"
	$('#fechaFin').val(formattedDate); // Asigna la fecha actual al campo "fechaFin"
  });

/*=============================================
OCULTAR Y MOSTRAR GRUPOS 
=============================================*/

$(document).ready(function() {

	// Función para ocultar todos los grupos excepto las fechas
	function ocultarTodo() {
	  $('#txtPlaca').closest('.form-group').hide();
	  $('#cboParada').closest('.form-group').hide();
	  $('#cbosubgrupo').closest('.form-group').hide();
	  $('#cbodigito').closest('.form-group').hide();
	  $('#cbodia').closest('.form-group').hide();
	  $('#cboagente').closest('.form-group').hide();
	  $('#cboimei').closest('.form-group').hide();
	  $('#fechaInicio').closest('.form-group').hide();
	  $('#fechaFin').closest('.form-group').hide();
	  $('.btnGenerarReporteExcel').closest('.form-group').hide();  // Cambiado a clase
	}
  
	// Mostrar/ocultar campos en función del tipo de reporte seleccionado
	$('#tipoReporteApp').change(function() {
	  var tipoReporte = $(this).val(); // Obtener el valor seleccionado
	  ocultarTodo(); // Ocultar todos los grupos al principio
  
	  // Mostrar los grupos correspondientes según el tipo de reporte
	  if (tipoReporte === 'REP_PARADA') {
		$('#cboParada').closest('.form-group').show(); // Mostrar selector de Parada
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
		$('.btnGenerarReporteExcel').closest('.form-group').show();  // Cambiado a clase
	  } else if (tipoReporte === 'REP_PLACA') {
		$('#txtPlaca').closest('.form-group').show(); // Mostrar campo de Placa
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_SUBGRUPO') {
		$('#cbosubgrupo').closest('.form-group').show(); // Mostrar selector de Sub Grupo
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
	  }else if (tipoReporte === 'REP_SUBGRUPOTOTAL') {
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_DIGITO') {
		$('#cbodigito').closest('.form-group').show(); // Mostrar selector de Dígito de Restricción
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_DIA') {
		$('#cbodia').closest('.form-group').show(); // Mostrar selector de Día de Restricción
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_VAGENTE') {
		$('#cboagente').closest('.form-group').show(); // Mostrar selector de Agente
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
		cargaAgentes("AGENTE");
	  } else if (tipoReporte === 'REP_IMEI') {
		$('#cboimei').closest('.form-group').show(); // Mostrar selector de IMEI o equipo despachante
		$('#fechaInicio').closest('.form-group').show();
		$('#fechaFin').closest('.form-group').show();
		cargaAgentes("DISPOSITIVO");
	  } else if (tipoReporte === 'REP_AGENTESEQUIPOS') {
		$('#fechaInicio').closest('.form-group').hide();
		$('#fechaFin').closest('.form-group').hide();
	  }
	}); 
  
	// Ocultar todos los grupos excepto las fechas al cargar la página
	ocultarTodo();
	// Mostrar el campo por defecto al cargar la página
	$('#tipoReporteApp').trigger('change');
  });
  
  function cargaAgentes(tipo){
	    var tipoBus = tipo;
		
		var datos = new FormData();
		datos.append("tipoBus", tipoBus);
		$.ajax({
	
			url:"ajax/reportesApp.ajax.php",
			method: "POST",
			data: datos,
			cache: false,
			contentType: false,
			processData: false,
			dataType: "json",
			success: function(respuesta){
				//console.log('Valor enviado desde JS a PHP:', respuesta.tipoBus); // Ver el valor de tipoBus
				$('#cboagente').empty();
				$('#cboimei').empty();
				if (Array.isArray(respuesta)) {
					if (tipoBus == 'AGENTE'){
						// Iterar sobre cada agente recibido
						respuesta.forEach(function(agente) {
							// Agregar cada opción al select, usando el id y NombreApp
							$('#cboagente').append('<option value="' + agente.NombreApp + '">' + agente.NombreApp + '</option>');
						});
					}else{
						respuesta.forEach(function(agente) {
							// Agregar cada opción al select, usando el id y NombreApp
							$('#cboimei').append('<option value="' + agente.ModCelular + '">' + agente.ModCelular + '</option>');
						});
					}
				} else {
					console.error('Respuesta no es un array válido:', respuesta);
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				console.error('Error en la solicitud AJAX:', textStatus, errorThrown);
			}
			
		});
		
  }