
/*=============================================
REPORTE APP
=============================================*/
$(document).on("click", ".btnGenerarReporteIngEgre", function(){

  var fechaInicio = $('#fechaInicioie').val();
  var fechaFin = $('#fechaFinie').val();
  var cborubroie = $('#cborubroigeg').val();
  var cbosocioie = $('#cbosocioigeg').val();
  var tipoReporteie = $('#tipoReporteIngEgr').val();
   
  //console.log('PHP:', formatoreporte);
  //console.log('PHP:', fechaFin);
  //console.log('PHP:', parada);

  if (!fechaInicio || !fechaFin) {
	Swal.fire({
		icon: "warning",
		title: "¡Debe seleccionar una fecha de inicio y una fecha final!",
		showConfirmButton: true,
		confirmButtonText: "CERRAR"
	}).then((result) => {
		if (result.isConfirmed) {
			window.location = "frmreportesingegre";
		}
	});
  }else{

	  // Convertir las fechas a objetos Date para comparar
	  var fechaInicioObj = new Date(fechaInicio);
	  var fechaFinObj = new Date(fechaFin);
	
	  // Validación de rango de fechas: fechaFin no debe ser mayor a fechaInicio
	  if (fechaFinObj < fechaInicioObj) {
		Swal.fire({
			icon: "warning",
			title: "¡La fecha de fin no puede ser menor que la fecha de inicio.!",
			showConfirmButton: true,
			confirmButtonText: "CERRAR"
		}).then((result) => {
			if (result.isConfirmed) {
				window.location = "frmreportesingegre";
			}
		});

	  }else{
			switch (tipoReporteie) {
				case "REP_INGRESOS":
					window.open("extensiones/tcpdf/pdf/reporteIngresos.php?fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_EGRESOS":
					window.open("extensiones/tcpdf/pdf/reporteEgresos.php?fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_ITEM":
					window.open("extensiones/tcpdf/pdf/reporteIngEgrRubro.php?rubroie="+cborubroie+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_GENERAL":
					window.open("extensiones/tcpdf/pdf/reporteGeneralie.php?fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_XSOCIO":
					window.open("extensiones/tcpdf/pdf/reporteIngEgrSocio.php?socioie="+cbosocioie+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
			}
			
	  }
  }  
})

/*=============================================
DATEPICKET
=============================================*/

  $(document).ready(function() {
    $('.datepicker').datepicker({
      format: 'yyyy-mm-dd',
      autoclose: true
    });
    // Obtener la fecha local actual
    var today = new Date();
    var year = today.getFullYear();
    var month = String(today.getMonth() + 1).padStart(2, '0'); // Meses comienzan desde 0
    var day = String(today.getDate()).padStart(2, '0'); // Día del mes

    var formattedDate = year + '-' + month + '-' + day; // Formato yyyy-mm-dd

	$('#fechaInicioie').val(formattedDate); // Asigna la fecha actual al campo "fechaInicio"
	$('#fechaFinie').val(formattedDate); // Asigna la fecha actual al campo "fechaFin"


	$('#btnBuscarSaldos').on('click', function(event) {
		event.preventDefault();
        CargarSaldos();
    });
  });

/*=============================================
OCULTAR Y MOSTRAR GRUPOS 
=============================================*/

$(document).ready(function() {

	// Función para ocultar todos los grupos excepto las fechas
	function ocultarTodo() {
	  $('#cborubroigeg').closest('.form-group').hide();
	  $('#cbosocioigeg').closest('.form-group').hide();
	  $('#fechaInicioie').closest('.form-group').hide();
	  $('#fechaFinie').closest('.form-group').hide();
	}
  
	// Mostrar/ocultar campos en función del tipo de reporte seleccionado
	$('#tipoReporteIngEgr').change(function() {
	  var tipoReporte = $(this).val(); // Obtener el valor seleccionado
	  ocultarTodo(); // Ocultar todos los grupos al principio
  
	  // Mostrar los grupos correspondientes según el tipo de reporte
	  if (tipoReporte === 'REP_INGRESOS') {
		$('#fechaInicioie').closest('.form-group').show();
		$('#fechaFinie').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_EGRESOS') {
		$('#fechaInicioie').closest('.form-group').show();
		$('#fechaFinie').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_ITEM') {
		$('#cborubroigeg').closest('.form-group').show();
		$('#fechaInicioie').closest('.form-group').show();
		$('#fechaFinie').closest('.form-group').show();
		CargarRubrosRep();
	  }else if (tipoReporte === 'REP_GENERAL') {
		$('#fechaInicioie').closest('.form-group').show();
		$('#fechaFinie').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_XSOCIO') {
		$('#cbosocioigeg').closest('.form-group').show(); // Mostrar selector de Dígito de Restricción
		$('#fechaInicioie').closest('.form-group').show();
		$('#fechaFinie').closest('.form-group').show();
		CargarSociosRep();
	  }
	}); 
  
	// Ocultar todos los grupos excepto las fechas al cargar la página
	ocultarTodo();
	// Mostrar el campo por defecto al cargar la página
	$('#tipoReporteIngEgr').trigger('change');
  });
  
/*=============================================
CARGA RUBROS
=============================================*/

function CargarRubrosRep(){
	var rubEstado = '1';
	//console.log('PHP: CARGAR GARANTES AQUI');
	var datos = new FormData();
	datos.append("rubEstado", rubEstado);
	$.ajax({

		url:"ajax/reportesingegre.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			//console.log('Valor enviado desde JS a PHP:', respuesta.tipoBus); // Ver el valor de tipoBus
			//$('#cbonuevoRubroIng').empty();
			$('#cborubroigeg').empty();
			if (Array.isArray(respuesta)) {
					// Iterar sobre cada agente recibido
					respuesta.forEach(function(rubros) {
						var cborubros = rubros.rubro.trim();  // Elimina los espacios en blanco al inicio y al final
						//$('#cbonuevoRubroIng').append('<option value="' + cborubros + '">' + cborubros + '</option>');
						$('#cborubroigeg').append('<option value="' + cborubros + '">' + cborubros + '</option>');
						});
			} else {
				console.error('Respuesta no es un array válido:', respuesta);
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			console.error('Error en la solicitud AJAX:', textStatus, errorThrown);
		}
		
	});
	
}

/*=============================================
CARGA SOCIOS
=============================================*/

function CargarSociosRep(){
	var buscarCiDeu = '%';

		var datos = new FormData();
		datos.append("cibuscaSocio", buscarCiDeu);
		$.ajax({
	
			url:"ajax/reportesingegre.ajax.php",
			method: "POST",
			data: datos,
			cache: false,
			contentType: false,
			processData: false,
			dataType: "json",
			success: function(respuesta){
				//console.log('Valor enviado desde JS a PHP:', respuesta.tipoBus); // Ver el valor de tipoBus
				//$('#cbonuevoRubroIng').empty();
				$('#cbosocioigeg').empty();
				if (Array.isArray(respuesta)) {
						// Iterar sobre cada agente recibido
						respuesta.forEach(function(socio) {
							var cbosocios = socio.nombre_completo.trim();  // Elimina los espacios en blanco al inicio y al final
							//$('#cbonuevoRubroIng').append('<option value="' + cborubros + '">' + cborubros + '</option>');
							$('#cbosocioigeg').append('<option value="' + cbosocios + '">' + cbosocios + '</option>');
							});
				} else {
					console.error('Respuesta no es un array válido:', respuesta);
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				console.error('Error en la solicitud AJAX:', textStatus, errorThrown);
			}		
		});
}

/*=============================================
REPORTE ARQUEO DE CAJA
=============================================*/

$(document).on("click", ".btnArqueoRep", function(){

	var coda = $(this).attr("coda");
	var usuario = $(this).attr("usrnomb");
	//console.log('PHP:', usuario); 
	var today = new Date();
    var year = today.getFullYear();
    var month = String(today.getMonth() + 1).padStart(2, '0'); // Meses comienzan desde 0
    var day = String(today.getDate()).padStart(2, '0'); // Día del mes

    var fechaActual = day + '-' + month + '-' + year; // Formato yyyy-mm-dd
	//console.log('PHP:', cifilePropietario);     
	window.open("extensiones/tcpdf/pdf/reporteArqueo.php?coda="+coda+"&usuario="+usuario,"_blank");
})


/*=============================================
CARGA SALDOS PARA CIERRE DIARIO
=============================================*/

function CargarSaldos(){

		var saldos = "1";
		var datos = new FormData();
		datos.append("saldos", saldos);
	
	//console.log('PHP: AQUI');
	$.ajax({

		url:"ajax/cierrediario.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			if(respuesta){
				var totalingresos = parseFloat(respuesta["totalingresos"]) || 0;
				var totalmensuales = parseFloat(respuesta["totalmensuales"]) || 0;
				var totalingresos = (totalingresos + totalmensuales);
                var totalegresos = parseFloat(respuesta["totalegresos"]) || 0;
                var saldoanterior = parseFloat(respuesta["saldoanterior"]) || 0;
                var saldoarqueo = parseFloat(respuesta["saldoarqueo"]) || 0;

                // Calcular saldos con valores numéricos
                var saldoingegr =  totalingresos - totalegresos;
                saldoingegr = parseFloat(saldoingegr.toFixed(2)); // Redondear a 2 decimales

                var saldocaja = saldoingegr + saldoanterior;
                saldocaja = parseFloat(saldocaja.toFixed(2)); // Redondear a 2 decimales

                var sobrantesfaltantes =  saldoanterior - (saldocaja - saldoarqueo);

                // Actualizar los campos del formulario
                $("#tingresos").val(totalingresos);
                $("#tegresos").val(totalegresos);
                $("#salanterior").val(saldoanterior);
                $("#saldoarqueo").val(saldoarqueo);
                $("#dependientes").val(respuesta["saldopendientes"]);
                $("#devencidas").val(respuesta["saldovencidos"]);
                $("#salingegr").val(saldoingegr);
                $("#saldocaja").val(saldocaja);
                

                var arqueocuando0 = saldoarqueo === 0 ? 0 : saldoarqueo;
                if (saldoingegr === 0 && arqueocuando0 === 0) {
                    $("#sobrfalta").val("0");
                } else {
                    $("#sobrfalta").val(sobrantesfaltantes.toFixed(2));
                }
					
	    	}else{
				Swal.fire({
					icon: "error",
					title: "¡No se recuperaron los saldos!",
					showConfirmButton: true,
					confirmButtonText: "CERRAR"
				}).then((result) => {

				});
			}			
		}

	});

}

/*=============================================
REPORTE CIERRE DIARIO
=============================================*/

$(document).on("click", ".btnCierreDiarioRep", function(){

	var codcd = $(this).attr("codcd");
	var fechacie = $(this).attr("fechacie");
/* 	var today = new Date();
    var year = today.getFullYear();
    var month = String(today.getMonth() + 1).padStart(2, '0'); // Meses comienzan desde 0
    var day = String(today.getDate()).padStart(2, '0'); // Día del mes

    var fechaActual = day + '-' + month + '-' + year; // Formato yyyy-mm-dd */
	//console.log('PHP:', cifilePropietario);     
	window.open("extensiones/tcpdf/pdf/reporteCierreDiario.php?codcd="+codcd+"&fechacierre="+fechacie,"_blank");
})