
/*=============================================
REPORTE APP
=============================================*/
$(document).on("click", ".btnGenerarReporteMensual", function(){

  var fechaInicio = $('#fechaIniciomen').val();
  var fechaFin = $('#fechaFinmen').val();
  var cbosociomen = $('#cbosociomen').val();
  var cbogestionrep = $('#cbogestionrep').val();
  var cbotipomen = $('#cbotipomen').val();
  var cborubromen = $('#cborubromen').val();
  var tipoReportemen = $('#tipoReporteMensual').val();
   
   if (!fechaInicio || !fechaFin) {
	Swal.fire({
		icon: "warning",
		title: "¡Debe seleccionar una fecha de inicio y una fecha final!",
		showConfirmButton: true,
		confirmButtonText: "CERRAR"
	}).then((result) => {
		if (result.isConfirmed) {
			window.location = "frmreportesdeudas";
		}
	});
  }else{

	  // Convertir las fechas a objetos Date para comparar
	  var fechaInicioObj = new Date(fechaInicio);
	  var fechaFinObj = new Date(fechaFin);
	
	  // Validación de rango de fechas: fechaFin no debe ser mayor a fechaInicio
	  if (fechaFinObj < fechaInicioObj) {
		Swal.fire({
			icon: "warning",
			title: "¡La fecha de fin no puede ser menor que la fecha de inicio.!",
			showConfirmButton: true,
			confirmButtonText: "CERRAR"
		}).then((result) => {
			if (result.isConfirmed) {
				window.location = "frmreportesdeudas";
			}
		});

	  }else{
			switch (tipoReportemen) {
				case "REP_EXTRACTO":
					window.open("extensiones/tcpdf/pdf/reporteExtractoSocio.php?sociomen="+cbosociomen+"&gestion="+cbogestionrep+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_GENERAL":
					window.open("extensiones/tcpdf/pdf/reporteMensualGeneral.php?estadomen="+cbotipomen+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				  break;
				case "REP_RUBRO":
					window.open("extensiones/tcpdf/pdf/reporteMensualRubro.php?rubromen="+cborubromen+"&fec_ini="+fechaInicio+"&fec_fin="+fechaFin,"_blank");
				break;
			}
			
	  }
  }  
})

/*=============================================
DATEPICKET
=============================================*/

  $(document).ready(function() {
    $('.datepicker').datepicker({
      format: 'yyyy-mm-dd',
      autoclose: true
    });
    // Obtener la fecha local actual
    var today = new Date();
    var year = today.getFullYear();
    var month = String(today.getMonth() + 1).padStart(2, '0'); // Meses comienzan desde 0
    var day = String(today.getDate()).padStart(2, '0'); // Día del mes

    var formattedDate = year + '-' + month + '-' + day; // Formato yyyy-mm-dd

	$('#fechaIniciomen').val(formattedDate); // Asigna la fecha actual al campo "fechaInicio"
	$('#fechaFinmen').val(formattedDate); // Asigna la fecha actual al campo "fechaFin"
  });

/*=============================================
OCULTAR Y MOSTRAR GRUPOS 
=============================================*/

$(document).ready(function() {

	// Función para ocultar todos los grupos excepto las fechas
	function ocultarTodo() {
	  $('#cbosociomen').closest('.form-group').hide();
	  $('#cbogestionrep').closest('.form-group').hide();
	  $('#cbotipomen').closest('.form-group').hide();
	  $('#cborubromen').closest('.form-group').hide();
	  $('#fechaIniciomen').closest('.form-group').hide();
	  $('#fechaFinmen').closest('.form-group').hide();
	}
  
	// Mostrar/ocultar campos en función del tipo de reporte seleccionado
	$('#tipoReporteMensual').change(function() {
	  var tipoReporte = $(this).val(); // Obtener el valor seleccionado
	  ocultarTodo(); // Ocultar todos los grupos al principio
  
	  // Mostrar los grupos correspondientes según el tipo de reporte
	  if (tipoReporte === 'REP_EXTRACTO') {
		$('#cbosociomen').closest('.form-group').show();
		$('#cbogestionrep').closest('.form-group').show();
		//$('#fechaIniciomen').closest('.form-group').show();
		//$('#fechaFinmen').closest('.form-group').show();
		CargarSociosMen();
	  } else if (tipoReporte === 'REP_GENERAL') {
		$('#cbotipomen').closest('.form-group').show();
		$('#fechaIniciomen').closest('.form-group').show();
		$('#fechaFinmen').closest('.form-group').show();
	  } else if (tipoReporte === 'REP_RUBRO') {
		$('#cborubromen').closest('.form-group').show();
		$('#fechaIniciomen').closest('.form-group').show();
		$('#fechaFinmen').closest('.form-group').show();
		CargarRubrosMen();
	  }
	}); 
  
	// Ocultar todos los grupos excepto las fechas al cargar la página
	ocultarTodo();
	// Mostrar el campo por defecto al cargar la página
	$('#tipoReporteMensual').trigger('change');
  });
  

/*=============================================
CARGA SOCIOS
=============================================*/

function CargarSociosMen(){
	var buscarCiDeu = '%';

		var datos = new FormData();
		datos.append("cibuscaSocio", buscarCiDeu);
		$.ajax({
	
			url:"ajax/reportesdeudas.ajax.php",
			method: "POST",
			data: datos,
			cache: false,
			contentType: false,
			processData: false,
			dataType: "json",
			success: function(respuesta){
				//console.log('Valor enviado desde JS a PHP:', respuesta.tipoBus); // Ver el valor de tipoBus
				//$('#cbonuevoRubroIng').empty();
				$('#cbosociomen').empty();
				if (Array.isArray(respuesta)) {
						// Iterar sobre cada agente recibido
						respuesta.forEach(function(socio) {
							var cbosocios = socio.nombre_completo.trim();  // Elimina los espacios en blanco al inicio y al final
							//$('#cbonuevoRubroIng').append('<option value="' + cborubros + '">' + cborubros + '</option>');
							$('#cbosociomen').append('<option value="' + cbosocios + '">' + cbosocios + '</option>');
							});
				} else {
					console.error('Respuesta no es un array válido:', respuesta);
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				console.error('Error en la solicitud AJAX:', textStatus, errorThrown);
			}		
		});
}
 
/*=============================================
CARGA RUBROS MENSUALES
=============================================*/

function CargarRubrosMen(){
	var rubEstado = '1';
	//console.log('PHP: CARGAR GARANTES AQUI');
	var datos = new FormData();
	datos.append("rubEstadoMen", rubEstado);
	$.ajax({

		url:"ajax/reportesdeudas.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			$('#cborubromen').empty();
			if (Array.isArray(respuesta)) {
					// Iterar sobre cada agente recibido
					respuesta.forEach(function(rubros) {
						var cborubros = rubros.rubro.trim();  // Elimina los espacios en blanco al inicio y al final
						//$('#cbonuevoRubroIng').append('<option value="' + cborubros + '">' + cborubros + '</option>');
						$('#cborubromen').append('<option value="' + cborubros + '">' + cborubros + '</option>');
						});
			} else {
				console.error('Respuesta no es un array válido:', respuesta);
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			console.error('Error en la solicitud AJAX:', textStatus, errorThrown);
		}
		
	});
	
}