<div class="content-wrapper">

  <section class="content-header">
    
    <h1>
      
      Administracion de Asalariados
    
    </h1>

    <ol class="breadcrumb">
      
      <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>
      
      <li class="active">Administrar Asalariados</li>
    
    </ol>

  </section>

  <section class="content">

    <div class="box">

      <div class="box-header with-border">
  
        <button class="btn btn-info fncCargaGarante" data-toggle="modal" data-target="#modalAgregarAsalariado">
          Agregar Asalariados
        </button>

      </div>

      <div class="box-body">
        
       <table class="table table-bordered table-striped dt-responsive tablas" width="100%">
         
        <thead>
         
         <tr>
           
           <th style="width:10px">#</th>
           <th>C.I.</th>
           <th>Nombres</th>
           <th>Apellidos</th>
           <th>Fec_Ingreso</th>
           <th>Celular</th>
           <th>Zona</th>
           <th>Calle</th>
           <th>Garante</th>
           <th>Estado</th>
           <th>Ante..</th>
           <th>Perm..</th>
           <th>Acciones</th>

         </tr> 

        </thead>

        <tbody>

        <?php

        $item = null;
        $valor = null;

        $asalariado = ControladorAsalariados::ctrMostrarAsalariados($item, $valor);

       foreach ($asalariado as $key => $value){

        $fec_ing = $value["fec_ingreso"];
				// Crear un objeto DateTime desde la cadena de fecha original
				$date = DateTime::createFromFormat('Y-m-d', $fec_ing);
				// Formatear la fecha al formato 'Y-m-d' (año-mes-día)
				$fec_ingreso = $date->format('d/m/Y');
         
          echo ' <tr>
                  <td>'.$value["id"].'</td>
                  <td>'.$value["ci"].'</td>
                  <td>'.$value["nombres"].'</td>
                  <td>'.$value["apellidos"].'</td>
                  <td>'.$fec_ingreso.'</td>
                  <td>'.$value["celular"].'</td>
                  <td>'.$value["direc_zona"].'</td>
                  <td>'.$value["direc_calle"].'</td>
                  <td>'.$value["nombre_garante"].'</td>';
          
                  if($value["estado"] == "0"){
                    echo '<td><button class="btn btn-danger btn-xs">Inactivo</button></td>';
                  }else{
                    echo '<td><button class="btn btn-success btn-xs">Activo</button></td>';
                  }  

                  if($value["antecedentes"] == "No" || trim($value["antecedentes"]) == ""){
                    echo '<td><button class="btn btn-default btn-xs">No</button></td>';
                  }else{
                    echo '<td><button class="btn btn-danger btn-xs btnVerantecedenteAsa" ciAsalariadoAnt="'.$value["ci"].'" data-toggle="modal" data-target="#modal-antecedentesAsa">Si</button></td>';
                  }

                  if($value["permiso"] == "No" || trim($value["permiso"]) == ""){
                    echo '<td><button class="btn btn-default btn-xs">No</button></td>';
                  }else{
                    echo '<td><button class="btn btn-info btn-xs btnVerpermisoAsa" ciAsalariadoPer="'.$value["ci"].'" data-toggle="modal" data-target="#modal-permisosAsa">Si</button></td>';
                  }

                  echo '</td>
                   <td>
                    <div class="btn-group">
                      <button class="btn btn-warning btnEditarAsalariado" ciAsalariado="'.$value["ci"].'" data-toggle="modal" data-target="#modalEditarAsalariado"><i class="fa fa-pencil"></i></button>
                      <button class="btn btn-success btnfileAsalariado" cifileAsalariado="'.$value["ci"].'"><i class="fa fa-file"></i></button>
                    </div>  
                  </td>
                </tr>';
        }
        ?> 

        </tbody>

       </table>

      </div>

    </div>

  </section>

</div>

<!--========================================================================================================================
MODAL AGREGAR PROPIETARIO
=========================================================================================================================-->
<div id="modalAgregarAsalariado" class="modal modal-info fade" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form role="form" method="post" enctype="multipart/form-data">
        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">NUEVO ASALARIADO</h4>
        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->
        <div class="modal-body">
          <div class="box-body">
            <!-- Agrupando los inputs en filas y columnas -->
            <div class="row">
              <!-- Columna 1 -->
              <div class="col-md-6">
                <!-- ENTRADA PARA EL CARNET -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="number" class="form-control input-lg" name="nuevoCi" placeholder="Carnet o /Licencia" required>
                  </div>
                </div>

                <!-- ENTRADA PARA EL NOMBRE -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="text" class="form-control input-lg" name="nuevoNombreAsa" placeholder="Ingresar nombre" id="nuevoNombreProp" required style="text-transform: uppercase;">
                  </div>
                </div>

                <!-- ENTRADA PARA EL APELLIDO -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="text" class="form-control input-lg" name="nuevoApellidos" placeholder="Ingresar Apellidos" required style="text-transform: uppercase;">
                  </div>
                </div>

                <!-- ENTRADA PARA EL CELULAR -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-phone"></i></span>
                    <input type="number" class="form-control input-lg" name="nuevoCelular" placeholder="Numero de Celular" required>
                  </div>
                </div>

                <!-- ENTRADA PARA DIRECCION ZONA -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-check"></i></span>
                    <input type="text" class="form-control input-lg" name="nuevoZona" placeholder="Ingrese la Zona" required style="text-transform: uppercase;">
                  </div>
                </div>

                <!-- ENTRADA PARA DIRECCION CALLE -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-check"></i></span>
                    <input type="text" class="form-control input-lg" name="nuevoCalle" placeholder="Ingrese la Calle" required style="text-transform: uppercase;">
                  </div>
                </div>
              </div>

              <!-- Columna 2 -->
              <div class="col-md-6">
                <!-- ENTRADA PARA EL FECHA INGRESO -->
                <div class="form-group">
                  <label>Fecha de Ingreso:</label>
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i>
                    </div>
                    <input type="text" class="form-control" name="nuevoFecingreso" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="">
                  </div>
                </div>

                <!-- ENTRADA PARA GARANTE -->
<!--                 <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-check"></i></span>
                    <input type="text" class="form-control input-lg" name="nuevoGarante" placeholder="Ingrese Nombre del Garante" required style="text-transform: uppercase;">
                  </div>
                </div> -->

                <!-- /.form-group -->
                <div class="form-group">
                  <label>Garante: </label>
                  <select class="form-control input-lg" id="cbonuevoGarante" name="cbonuevoGarante"> <!-- Cambia el id aquí -->

                  </select>
                </div>

                <!-- ENTRADA PARA ANTECEDENTES -->
                <div class="form-group has-error">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-bell"></i></span>
                    <textarea class="form-control" rows="4" name="nuevoAntecedentes" placeholder="Ingrese los Antecedentes"></textarea>
                  </div>
                </div>

                <!-- ENTRADA PARA PERMISOS -->
                <div class="form-group has-error">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-bell"></i></span>
                    <textarea class="form-control" rows="4" name="nuevoPermiso" placeholder="Ingrese Permisos"></textarea>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->
        <div class="modal-footer">
          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>
          <button type="submit" class="btn btn-success">Guardar Asalariado</button>
        </div>

        <?php
          $crearAsalariado = new ControladorAsalariados();
          $crearAsalariado -> ctrCrearAsalariado();
        ?>
      </form>
    </div>
  </div>
</div>


<!--=======================================================================================================0==================
MODAL EDITAR PROPIETARIO
===================================================================================================================0========-->


<div id="modalEditarAsalariado" class="modal modal-warning fade" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form role="form" method="post" enctype="multipart/form-data">
        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->
        <div class="modal-header" style="background:#3c8dbc; color:white">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Editar Asalariado</h4>
        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->
        <div class="modal-body">
          <div class="box-body">
            <!-- Agrupando los inputs en filas y columnas -->
            <div class="row">
              <!-- Columna 1 -->
              <div class="col-md-6">
                <!-- ENTRADA PARA EL CARNET -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="number" class="form-control input-lg" id="editarci" name="editarci" readonly>
                  </div>
                </div>

                <!-- ENTRADA PARA EL NOMBRE -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="text" class="form-control input-lg" id="editarNombreAsa" name="editarNombreAsa" value="" style="text-transform: uppercase;" required>
                  </div>
                </div>

                <!-- ENTRADA PARA EL APELLIDO -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="text" class="form-control input-lg" id="editarApellidos" name="editarApellidos" value="" required style="text-transform: uppercase;">
                  </div>
                </div>

                <!-- ENTRADA PARA EL CELULAR -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-phone"></i></span>
                    <input type="number" class="form-control input-lg" id="editarCelular" name="editarCelular" value="" required>
                  </div>
                </div>

                <!-- ENTRADA PARA DIRECCION ZONA -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-check"></i></span>
                    <input type="text" class="form-control input-lg" id="editarZona" name="editarZona" value="" required style="text-transform: uppercase;">
                  </div>
                </div>

                <!-- ENTRADA PARA DIRECCION CALLE -->
                <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-check"></i></span>
                    <input type="text" class="form-control input-lg" id="editarCalle" name="editarCalle" value="" required style="text-transform: uppercase;">
                  </div>
                </div>
              </div>

              <!-- Columna 2 -->
              <div class="col-md-6">
                <!-- ENTRADA PARA EL FECHA INGRESO -->
                <div class="form-group">
                  <label>Fecha de Ingreso:</label>
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i>
                    </div>
                    <input type="text" class="form-control" id="editarFecingreso" name="editarFecingreso" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="">
                  </div>
                </div>

                <!-- ENTRADA PARA GARANTE -->
<!--                 <div class="form-group">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-check"></i></span>
                    <input type="text" class="form-control input-lg" id="editarGarante" name="editarGarante" value="" required style="text-transform: uppercase;">
                  </div>
                </div> -->

                                <!-- /.form-group -->
                <div class="form-group">
                  <label>Garante: </label>
                  <select class="form-control input-lg" id="editarGarante" name="editarGarante"> <!-- Cambia el id aquí -->
                  </select>
                </div>

                <!-- ENTRADA PARA ANTECEDENTES -->
                <div class="form-group has-error">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-bell"></i></span>
                    <textarea class="form-control input-lg" rows="4" id="editarantecedentes" name="editarantecedentes" value=""></textarea>
                  </div>
                </div>

                <!-- ENTRADA PARA PERMISOS -->
                <div class="form-group has-error">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-bell"></i></span>
                    <textarea class="form-control input-lg" rows="4" id="editarPermiso" name="editarPermiso" value=""></textarea>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->
        <div class="modal-footer">
          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>
          <button type="submit" class="btn btn-success">Guardar Asalariado</button>
        </div>

        <?php
          $editarAsalariado = new ControladorAsalariados();
          $editarAsalariado -> ctrEditarAsalariado();
        ?>
      </form>
    </div>
  </div>
</div>

<!--=======================================================================================================0==================
MODAL ANTECEDENTES
===================================================================================================================0========-->

<div class="modal modal-danger fade" id="modal-antecedentesAsa" style="display: none;">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span></button>
          <h4 class="modal-title">ANTECEDENTES DEL ASALARIADO</h4>
      </div>
      <div class="modal-body">
          <!-- ENTRADA PARA ANTECEDENTES -->
          <div class="form-group has-error">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-bell"></i></span>
                    <textarea class="form-control input-lg" rows="4" id="mostrarAntecedentes" name="mostrarAntecedentes" readonly></textarea>
                  </div>
          </div>
      </div>
          <div class="modal-footer">
          <button type="button" class="btn btn-outline pull-right" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!--=======================================================================================================0==================
MODAL ANTECEDENTES
===================================================================================================================0========-->

<div class="modal modal-info fade" id="modal-permisosAsa" style="display: none;">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span></button>
          <h4 class="modal-title">PERMISOS DEL ASALARIADO</h4>
      </div>
      <div class="modal-body">
          <!-- ENTRADA PARA ANTECEDENTES -->
          <div class="form-group has-error">
                  <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-bell"></i></span>
                    <textarea class="form-control input-lg" rows="4" id="mostrarPermisos" name="mostrarPermisos" readonly></textarea>
                  </div>
          </div>
      </div>
          <div class="modal-footer">
          <button type="button" class="btn btn-outline pull-right" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

